// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The access keys for the cognitive services account.
/// </summary>
public partial class ServiceAccountApiKeys : ProvisionableConstruct
{
    /// <summary>
    /// Gets the value of key 1.
    /// </summary>
    public BicepValue<string> Key1 
    {
        get { Initialize(); return _key1!; }
    }
    private BicepValue<string>? _key1;

    /// <summary>
    /// Gets the value of key 2.
    /// </summary>
    public BicepValue<string> Key2 
    {
        get { Initialize(); return _key2!; }
    }
    private BicepValue<string>? _key2;

    /// <summary>
    /// Creates a new ServiceAccountApiKeys.
    /// </summary>
    public ServiceAccountApiKeys()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServiceAccountApiKeys.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _key1 = DefineProperty<string>("Key1", ["key1"], isOutput: true, isSecure: true);
        _key2 = DefineProperty<string>("Key2", ["key2"], isOutput: true, isSecure: true);
    }
}
