// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Cognitive Services account commitment quota.
/// </summary>
public partial class CommitmentQuota : ProvisionableConstruct
{
    /// <summary>
    /// Commitment quota quantity.
    /// </summary>
    public BicepValue<long> Quantity 
    {
        get { Initialize(); return _quantity!; }
    }
    private BicepValue<long>? _quantity;

    /// <summary>
    /// Commitment quota unit.
    /// </summary>
    public BicepValue<string> Unit 
    {
        get { Initialize(); return _unit!; }
    }
    private BicepValue<string>? _unit;

    /// <summary>
    /// Creates a new CommitmentQuota.
    /// </summary>
    public CommitmentQuota()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommitmentQuota.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _quantity = DefineProperty<long>("Quantity", ["quantity"], isOutput: true);
        _unit = DefineProperty<string>("Unit", ["unit"], isOutput: true);
    }
}
