// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties of Cognitive Services account commitment plan.
/// </summary>
public partial class CommitmentPlanProperties : ProvisionableConstruct
{
    /// <summary>
    /// Gets the status of the resource at the time the operation was called.
    /// </summary>
    public BicepValue<CommitmentPlanProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<CommitmentPlanProvisioningState>? _provisioningState;

    /// <summary>
    /// Commitment plan guid.
    /// </summary>
    public BicepValue<Guid> CommitmentPlanGuid 
    {
        get { Initialize(); return _commitmentPlanGuid!; }
        set { Initialize(); _commitmentPlanGuid!.Assign(value); }
    }
    private BicepValue<Guid>? _commitmentPlanGuid;

    /// <summary>
    /// Account hosting model.
    /// </summary>
    public BicepValue<ServiceAccountHostingModel> HostingModel 
    {
        get { Initialize(); return _hostingModel!; }
        set { Initialize(); _hostingModel!.Assign(value); }
    }
    private BicepValue<ServiceAccountHostingModel>? _hostingModel;

    /// <summary>
    /// Commitment plan type.
    /// </summary>
    public BicepValue<string> PlanType 
    {
        get { Initialize(); return _planType!; }
        set { Initialize(); _planType!.Assign(value); }
    }
    private BicepValue<string>? _planType;

    /// <summary>
    /// Cognitive Services account commitment period.
    /// </summary>
    public CommitmentPeriod Current 
    {
        get { Initialize(); return _current!; }
        set { Initialize(); AssignOrReplace(ref _current, value); }
    }
    private CommitmentPeriod? _current;

    /// <summary>
    /// AutoRenew commitment plan.
    /// </summary>
    public BicepValue<bool> AutoRenew 
    {
        get { Initialize(); return _autoRenew!; }
        set { Initialize(); _autoRenew!.Assign(value); }
    }
    private BicepValue<bool>? _autoRenew;

    /// <summary>
    /// Cognitive Services account commitment period.
    /// </summary>
    public CommitmentPeriod Next 
    {
        get { Initialize(); return _next!; }
        set { Initialize(); AssignOrReplace(ref _next, value); }
    }
    private CommitmentPeriod? _next;

    /// <summary>
    /// Cognitive Services account commitment period.
    /// </summary>
    public CommitmentPeriod Last 
    {
        get { Initialize(); return _last!; }
    }
    private CommitmentPeriod? _last;

    /// <summary>
    /// The list of ProvisioningIssue.
    /// </summary>
    public BicepList<string> ProvisioningIssues 
    {
        get { Initialize(); return _provisioningIssues!; }
    }
    private BicepList<string>? _provisioningIssues;

    /// <summary>
    /// Creates a new CommitmentPlanProperties.
    /// </summary>
    public CommitmentPlanProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommitmentPlanProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<CommitmentPlanProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _commitmentPlanGuid = DefineProperty<Guid>("CommitmentPlanGuid", ["commitmentPlanGuid"]);
        _hostingModel = DefineProperty<ServiceAccountHostingModel>("HostingModel", ["hostingModel"]);
        _planType = DefineProperty<string>("PlanType", ["planType"]);
        _current = DefineModelProperty<CommitmentPeriod>("Current", ["current"]);
        _autoRenew = DefineProperty<bool>("AutoRenew", ["autoRenew"]);
        _next = DefineModelProperty<CommitmentPeriod>("Next", ["next"]);
        _last = DefineModelProperty<CommitmentPeriod>("Last", ["last"], isOutput: true);
        _provisioningIssues = DefineListProperty<string>("ProvisioningIssues", ["provisioningIssues"], isOutput: true);
    }
}
