// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The commitment plan association.
/// </summary>
public partial class CommitmentPlanAssociation : ProvisionableConstruct
{
    /// <summary>
    /// The Azure resource id of the commitment plan.
    /// </summary>
    public BicepValue<ResourceIdentifier> CommitmentPlanId 
    {
        get { Initialize(); return _commitmentPlanId!; }
    }
    private BicepValue<ResourceIdentifier>? _commitmentPlanId;

    /// <summary>
    /// The location of of the commitment plan.
    /// </summary>
    public BicepValue<string> CommitmentPlanLocation 
    {
        get { Initialize(); return _commitmentPlanLocation!; }
    }
    private BicepValue<string>? _commitmentPlanLocation;

    /// <summary>
    /// Creates a new CommitmentPlanAssociation.
    /// </summary>
    public CommitmentPlanAssociation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommitmentPlanAssociation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _commitmentPlanId = DefineProperty<ResourceIdentifier>("CommitmentPlanId", ["commitmentPlanId"], isOutput: true);
        _commitmentPlanLocation = DefineProperty<string>("CommitmentPlanLocation", ["commitmentPlanLocation"], isOutput: true);
    }
}
