// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Cognitive Services account commitment period.
/// </summary>
public partial class CommitmentPeriod : ProvisionableConstruct
{
    /// <summary>
    /// Commitment period commitment tier.
    /// </summary>
    public BicepValue<string> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<string>? _tier;

    /// <summary>
    /// Commitment period commitment count.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// Cognitive Services account commitment quota.
    /// </summary>
    public CommitmentQuota Quota 
    {
        get { Initialize(); return _quota!; }
    }
    private CommitmentQuota? _quota;

    /// <summary>
    /// Commitment period start date.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Commitment period end date.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// Creates a new CommitmentPeriod.
    /// </summary>
    public CommitmentPeriod()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CommitmentPeriod.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tier = DefineProperty<string>("Tier", ["tier"]);
        _count = DefineProperty<int>("Count", ["count"]);
        _quota = DefineModelProperty<CommitmentQuota>("Quota", ["quota"], isOutput: true);
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startDate"], isOutput: true);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["endDate"], isOutput: true);
    }
}
