// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// A rule governing the accessibility from a specific virtual network.
/// </summary>
public partial class CognitiveServicesVirtualNetworkRule : ProvisionableConstruct
{
    /// <summary>
    /// Full resource id of a vnet subnet, such as
    /// &apos;/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1&apos;.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the state of virtual network rule.
    /// </summary>
    public BicepValue<string> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<string>? _state;

    /// <summary>
    /// Ignore missing vnet service endpoint or not.
    /// </summary>
    public BicepValue<bool> IgnoreMissingVnetServiceEndpoint 
    {
        get { Initialize(); return _ignoreMissingVnetServiceEndpoint!; }
        set { Initialize(); _ignoreMissingVnetServiceEndpoint!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreMissingVnetServiceEndpoint;

    /// <summary>
    /// Creates a new CognitiveServicesVirtualNetworkRule.
    /// </summary>
    public CognitiveServicesVirtualNetworkRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesVirtualNetworkRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"]);
        _state = DefineProperty<string>("State", ["state"]);
        _ignoreMissingVnetServiceEndpoint = DefineProperty<bool>("IgnoreMissingVnetServiceEndpoint", ["ignoreMissingVnetServiceEndpoint"]);
    }
}
