// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The call rate limit Cognitive Services account.
/// </summary>
public partial class CognitiveServicesRegionSetting : ProvisionableConstruct
{
    /// <summary>
    /// Name of the region.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// A value for priority or weighted routing methods.
    /// </summary>
    public BicepValue<float> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<float>? _value;

    /// <summary>
    /// Maps the region to the regional custom subdomain.
    /// </summary>
    public BicepValue<string> Customsubdomain 
    {
        get { Initialize(); return _customsubdomain!; }
        set { Initialize(); _customsubdomain!.Assign(value); }
    }
    private BicepValue<string>? _customsubdomain;

    /// <summary>
    /// Creates a new CognitiveServicesRegionSetting.
    /// </summary>
    public CognitiveServicesRegionSetting()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesRegionSetting.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<float>("Value", ["value"]);
        _customsubdomain = DefineProperty<string>("Customsubdomain", ["customsubdomain"]);
    }
}
