// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// A set of rules governing the network accessibility.
/// </summary>
public partial class CognitiveServicesNetworkRuleSet : ProvisionableConstruct
{
    /// <summary>
    /// The default action when no rule from ipRules and from
    /// virtualNetworkRules match. This is only used after the bypass property
    /// has been evaluated.
    /// </summary>
    public BicepValue<CognitiveServicesNetworkRuleAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<CognitiveServicesNetworkRuleAction>? _defaultAction;

    /// <summary>
    /// The list of IP address rules.
    /// </summary>
    public BicepList<CognitiveServicesIPRule> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<CognitiveServicesIPRule>? _iPRules;

    /// <summary>
    /// The list of virtual network rules.
    /// </summary>
    public BicepList<CognitiveServicesVirtualNetworkRule> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<CognitiveServicesVirtualNetworkRule>? _virtualNetworkRules;

    /// <summary>
    /// Creates a new CognitiveServicesNetworkRuleSet.
    /// </summary>
    public CognitiveServicesNetworkRuleSet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _defaultAction = DefineProperty<CognitiveServicesNetworkRuleAction>("DefaultAction", ["defaultAction"]);
        _iPRules = DefineListProperty<CognitiveServicesIPRule>("IPRules", ["ipRules"]);
        _virtualNetworkRules = DefineListProperty<CognitiveServicesVirtualNetworkRule>("VirtualNetworkRules", ["virtualNetworkRules"]);
    }
}
