// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The multiregion settings Cognitive Services account.
/// </summary>
public partial class CognitiveServicesMultiRegionSettings : ProvisionableConstruct
{
    /// <summary>
    /// Multiregion routing methods.
    /// </summary>
    public BicepValue<CognitiveServicesRoutingMethod> RoutingMethod 
    {
        get { Initialize(); return _routingMethod!; }
        set { Initialize(); _routingMethod!.Assign(value); }
    }
    private BicepValue<CognitiveServicesRoutingMethod>? _routingMethod;

    /// <summary>
    /// Gets the regions.
    /// </summary>
    public BicepList<CognitiveServicesRegionSetting> Regions 
    {
        get { Initialize(); return _regions!; }
        set { Initialize(); _regions!.Assign(value); }
    }
    private BicepList<CognitiveServicesRegionSetting>? _regions;

    /// <summary>
    /// Creates a new CognitiveServicesMultiRegionSettings.
    /// </summary>
    public CognitiveServicesMultiRegionSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesMultiRegionSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _routingMethod = DefineProperty<CognitiveServicesRoutingMethod>("RoutingMethod", ["routingMethod"]);
        _regions = DefineListProperty<CognitiveServicesRegionSetting>("Regions", ["regions"]);
    }
}
