// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Describes an available Cognitive Services Model SKU.
/// </summary>
public partial class CognitiveServicesModelSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the model SKU.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The usage name of the model SKU.
    /// </summary>
    public BicepValue<string> UsageName 
    {
        get { Initialize(); return _usageName!; }
        set { Initialize(); _usageName!.Assign(value); }
    }
    private BicepValue<string>? _usageName;

    /// <summary>
    /// The datetime of deprecation of the model SKU.
    /// </summary>
    public BicepValue<DateTimeOffset> DeprecationOn 
    {
        get { Initialize(); return _deprecationOn!; }
        set { Initialize(); _deprecationOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _deprecationOn;

    /// <summary>
    /// The capacity configuration.
    /// </summary>
    public CognitiveServicesCapacityConfig Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); AssignOrReplace(ref _capacity, value); }
    }
    private CognitiveServicesCapacityConfig? _capacity;

    /// <summary>
    /// The list of rateLimit.
    /// </summary>
    public BicepList<ServiceAccountCallRateLimit> RateLimits 
    {
        get { Initialize(); return _rateLimits!; }
    }
    private BicepList<ServiceAccountCallRateLimit>? _rateLimits;

    /// <summary>
    /// Creates a new CognitiveServicesModelSku.
    /// </summary>
    public CognitiveServicesModelSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CognitiveServicesModelSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _usageName = DefineProperty<string>("UsageName", ["usageName"]);
        _deprecationOn = DefineProperty<DateTimeOffset>("DeprecationOn", ["deprecationDate"]);
        _capacity = DefineModelProperty<CognitiveServicesCapacityConfig>("Capacity", ["capacity"]);
        _rateLimits = DefineListProperty<ServiceAccountCallRateLimit>("RateLimits", ["rateLimits"], isOutput: true);
    }
}
