// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties to configure keyVault Properties.
/// </summary>
public partial class CognitiveServicesKeyVaultProperties : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Key from KeyVault.
    /// </summary>
    public BicepValue<string> KeyName 
    {
        get { Initialize(); return _keyName!; }
        set { Initialize(); _keyName!.Assign(value); }
    }
    private BicepValue<string>? _keyName;

    /// <summary>
    /// Version of the Key from KeyVault.
    /// </summary>
    public BicepValue<string> KeyVersion 
    {
        get { Initialize(); return _keyVersion!; }
        set { Initialize(); _keyVersion!.Assign(value); }
    }
    private BicepValue<string>? _keyVersion;

    /// <summary>
    /// Uri of KeyVault.
    /// </summary>
    public BicepValue<Uri> KeyVaultUri 
    {
        get { Initialize(); return _keyVaultUri!; }
        set { Initialize(); _keyVaultUri!.Assign(value); }
    }
    private BicepValue<Uri>? _keyVaultUri;

    /// <summary>
    /// Gets or sets the identity client id.
    /// </summary>
    public BicepValue<Guid> IdentityClientId 
    {
        get { Initialize(); return _identityClientId!; }
        set { Initialize(); _identityClientId!.Assign(value); }
    }
    private BicepValue<Guid>? _identityClientId;

    /// <summary>
    /// Creates a new CognitiveServicesKeyVaultProperties.
    /// </summary>
    public CognitiveServicesKeyVaultProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesKeyVaultProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyName = DefineProperty<string>("KeyName", ["keyName"]);
        _keyVersion = DefineProperty<string>("KeyVersion", ["keyVersion"]);
        _keyVaultUri = DefineProperty<Uri>("KeyVaultUri", ["keyVaultUri"]);
        _identityClientId = DefineProperty<Guid>("IdentityClientId", ["identityClientId"]);
    }
}
