// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The capacity configuration.
/// </summary>
public partial class CognitiveServicesCapacityConfig : ProvisionableConstruct
{
    /// <summary>
    /// The minimum capacity.
    /// </summary>
    public BicepValue<int> Minimum 
    {
        get { Initialize(); return _minimum!; }
        set { Initialize(); _minimum!.Assign(value); }
    }
    private BicepValue<int>? _minimum;

    /// <summary>
    /// The maximum capacity.
    /// </summary>
    public BicepValue<int> Maximum 
    {
        get { Initialize(); return _maximum!; }
        set { Initialize(); _maximum!.Assign(value); }
    }
    private BicepValue<int>? _maximum;

    /// <summary>
    /// The minimal incremental between allowed values for capacity.
    /// </summary>
    public BicepValue<int> Step 
    {
        get { Initialize(); return _step!; }
        set { Initialize(); _step!.Assign(value); }
    }
    private BicepValue<int>? _step;

    /// <summary>
    /// The default capacity.
    /// </summary>
    public BicepValue<int> Default 
    {
        get { Initialize(); return _default!; }
        set { Initialize(); _default!.Assign(value); }
    }
    private BicepValue<int>? _default;

    /// <summary>
    /// Creates a new CognitiveServicesCapacityConfig.
    /// </summary>
    public CognitiveServicesCapacityConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesCapacityConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _minimum = DefineProperty<int>("Minimum", ["minimum"]);
        _maximum = DefineProperty<int>("Maximum", ["maximum"]);
        _step = DefineProperty<int>("Step", ["step"]);
        _default = DefineProperty<int>("Default", ["default"]);
    }
}
