// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties of Cognitive Services account.
/// </summary>
public partial class CognitiveServicesAccountProperties : ProvisionableConstruct
{
    /// <summary>
    /// Gets the status of the cognitive services account at the time the
    /// operation was called.
    /// </summary>
    public BicepValue<ServiceAccountProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ServiceAccountProvisioningState>? _provisioningState;

    /// <summary>
    /// Endpoint of the created account.
    /// </summary>
    public BicepValue<string> Endpoint 
    {
        get { Initialize(); return _endpoint!; }
    }
    private BicepValue<string>? _endpoint;

    /// <summary>
    /// Gets the capabilities of the cognitive services account. Each item
    /// indicates the capability of a specific feature. The values are
    /// read-only and for reference only.
    /// </summary>
    public BicepList<CognitiveServicesSkuCapability> Capabilities 
    {
        get { Initialize(); return _capabilities!; }
    }
    private BicepList<CognitiveServicesSkuCapability>? _capabilities;

    /// <summary>
    /// If the resource is migrated from an existing key.
    /// </summary>
    public BicepValue<bool> IsMigrated 
    {
        get { Initialize(); return _isMigrated!; }
    }
    private BicepValue<bool>? _isMigrated;

    /// <summary>
    /// Resource migration token.
    /// </summary>
    public BicepValue<string> MigrationToken 
    {
        get { Initialize(); return _migrationToken!; }
        set { Initialize(); _migrationToken!.Assign(value); }
    }
    private BicepValue<string>? _migrationToken;

    /// <summary>
    /// Sku change info of account.
    /// </summary>
    public CognitiveServicesSkuChangeInfo SkuChangeInfo 
    {
        get { Initialize(); return _skuChangeInfo!; }
    }
    private CognitiveServicesSkuChangeInfo? _skuChangeInfo;

    /// <summary>
    /// Optional subdomain name used for token-based authentication.
    /// </summary>
    public BicepValue<string> CustomSubDomainName 
    {
        get { Initialize(); return _customSubDomainName!; }
        set { Initialize(); _customSubDomainName!.Assign(value); }
    }
    private BicepValue<string>? _customSubDomainName;

    /// <summary>
    /// A collection of rules governing the accessibility from specific network
    /// locations.
    /// </summary>
    public CognitiveServicesNetworkRuleSet NetworkAcls 
    {
        get { Initialize(); return _networkAcls!; }
        set { Initialize(); AssignOrReplace(ref _networkAcls, value); }
    }
    private CognitiveServicesNetworkRuleSet? _networkAcls;

    /// <summary>
    /// The encryption properties for this resource.
    /// </summary>
    public ServiceAccountEncryptionProperties Encryption 
    {
        get { Initialize(); return _encryption!; }
        set { Initialize(); AssignOrReplace(ref _encryption, value); }
    }
    private ServiceAccountEncryptionProperties? _encryption;

    /// <summary>
    /// The storage accounts for this resource.
    /// </summary>
    public BicepList<ServiceAccountUserOwnedStorage> UserOwnedStorage 
    {
        get { Initialize(); return _userOwnedStorage!; }
        set { Initialize(); _userOwnedStorage!.Assign(value); }
    }
    private BicepList<ServiceAccountUserOwnedStorage>? _userOwnedStorage;

    /// <summary>
    /// The private endpoint connection associated with the Cognitive Services
    /// account.
    /// </summary>
    public BicepList<CognitiveServicesPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<CognitiveServicesPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Whether or not public endpoint access is allowed for this account.
    /// </summary>
    public BicepValue<ServiceAccountPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<ServiceAccountPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// The api properties for special APIs.
    /// </summary>
    public ServiceAccountApiProperties ApiProperties 
    {
        get { Initialize(); return _apiProperties!; }
        set { Initialize(); AssignOrReplace(ref _apiProperties, value); }
    }
    private ServiceAccountApiProperties? _apiProperties;

    /// <summary>
    /// Gets the date of cognitive services account creation.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The call rate limit Cognitive Services account.
    /// </summary>
    public ServiceAccountCallRateLimit CallRateLimit 
    {
        get { Initialize(); return _callRateLimit!; }
    }
    private ServiceAccountCallRateLimit? _callRateLimit;

    /// <summary>
    /// The flag to enable dynamic throttling.
    /// </summary>
    public BicepValue<bool> EnableDynamicThrottling 
    {
        get { Initialize(); return _enableDynamicThrottling!; }
        set { Initialize(); _enableDynamicThrottling!.Assign(value); }
    }
    private BicepValue<bool>? _enableDynamicThrottling;

    /// <summary>
    /// Gets the quota limit.
    /// </summary>
    public ServiceAccountQuotaLimit QuotaLimit 
    {
        get { Initialize(); return _quotaLimit!; }
    }
    private ServiceAccountQuotaLimit? _quotaLimit;

    /// <summary>
    /// Gets or sets the restrict outbound network access.
    /// </summary>
    public BicepValue<bool> RestrictOutboundNetworkAccess 
    {
        get { Initialize(); return _restrictOutboundNetworkAccess!; }
        set { Initialize(); _restrictOutboundNetworkAccess!.Assign(value); }
    }
    private BicepValue<bool>? _restrictOutboundNetworkAccess;

    /// <summary>
    /// Gets the allowed fqdn list.
    /// </summary>
    public BicepList<string> AllowedFqdnList 
    {
        get { Initialize(); return _allowedFqdnList!; }
        set { Initialize(); _allowedFqdnList!.Assign(value); }
    }
    private BicepList<string>? _allowedFqdnList;

    /// <summary>
    /// Gets or sets the disable local auth.
    /// </summary>
    public BicepValue<bool> DisableLocalAuth 
    {
        get { Initialize(); return _disableLocalAuth!; }
        set { Initialize(); _disableLocalAuth!.Assign(value); }
    }
    private BicepValue<bool>? _disableLocalAuth;

    /// <summary>
    /// Dictionary of &lt;string&gt;.
    /// </summary>
    public BicepDictionary<string> Endpoints 
    {
        get { Initialize(); return _endpoints!; }
    }
    private BicepDictionary<string>? _endpoints;

    /// <summary>
    /// Gets or sets the restore.
    /// </summary>
    public BicepValue<bool> Restore 
    {
        get { Initialize(); return _restore!; }
        set { Initialize(); _restore!.Assign(value); }
    }
    private BicepValue<bool>? _restore;

    /// <summary>
    /// The deletion date, only available for deleted account.
    /// </summary>
    public BicepValue<DateTimeOffset> DeletedOn 
    {
        get { Initialize(); return _deletedOn!; }
    }
    private BicepValue<DateTimeOffset>? _deletedOn;

    /// <summary>
    /// The scheduled purge date, only available for deleted account.
    /// </summary>
    public BicepValue<string> ScheduledPurgeDate 
    {
        get { Initialize(); return _scheduledPurgeDate!; }
    }
    private BicepValue<string>? _scheduledPurgeDate;

    /// <summary>
    /// The multiregion settings of Cognitive Services account.
    /// </summary>
    public CognitiveServicesMultiRegionSettings Locations 
    {
        get { Initialize(); return _locations!; }
        set { Initialize(); AssignOrReplace(ref _locations, value); }
    }
    private CognitiveServicesMultiRegionSettings? _locations;

    /// <summary>
    /// The commitment plan associations of Cognitive Services account.
    /// </summary>
    public BicepList<CommitmentPlanAssociation> CommitmentPlanAssociations 
    {
        get { Initialize(); return _commitmentPlanAssociations!; }
    }
    private BicepList<CommitmentPlanAssociation>? _commitmentPlanAssociations;

    /// <summary>
    /// The abuse penalty.
    /// </summary>
    public AbusePenalty AbusePenalty 
    {
        get { Initialize(); return _abusePenalty!; }
    }
    private AbusePenalty? _abusePenalty;

    /// <summary>
    /// Creates a new CognitiveServicesAccountProperties.
    /// </summary>
    public CognitiveServicesAccountProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesAccountProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<ServiceAccountProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _endpoint = DefineProperty<string>("Endpoint", ["endpoint"], isOutput: true);
        _capabilities = DefineListProperty<CognitiveServicesSkuCapability>("Capabilities", ["capabilities"], isOutput: true);
        _isMigrated = DefineProperty<bool>("IsMigrated", ["isMigrated"], isOutput: true);
        _migrationToken = DefineProperty<string>("MigrationToken", ["migrationToken"]);
        _skuChangeInfo = DefineModelProperty<CognitiveServicesSkuChangeInfo>("SkuChangeInfo", ["skuChangeInfo"], isOutput: true);
        _customSubDomainName = DefineProperty<string>("CustomSubDomainName", ["customSubDomainName"]);
        _networkAcls = DefineModelProperty<CognitiveServicesNetworkRuleSet>("NetworkAcls", ["networkAcls"]);
        _encryption = DefineModelProperty<ServiceAccountEncryptionProperties>("Encryption", ["encryption"]);
        _userOwnedStorage = DefineListProperty<ServiceAccountUserOwnedStorage>("UserOwnedStorage", ["userOwnedStorage"]);
        _privateEndpointConnections = DefineListProperty<CognitiveServicesPrivateEndpointConnectionData>("PrivateEndpointConnections", ["privateEndpointConnections"], isOutput: true);
        _publicNetworkAccess = DefineProperty<ServiceAccountPublicNetworkAccess>("PublicNetworkAccess", ["publicNetworkAccess"]);
        _apiProperties = DefineModelProperty<ServiceAccountApiProperties>("ApiProperties", ["apiProperties"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["dateCreated"], isOutput: true);
        _callRateLimit = DefineModelProperty<ServiceAccountCallRateLimit>("CallRateLimit", ["callRateLimit"], isOutput: true);
        _enableDynamicThrottling = DefineProperty<bool>("EnableDynamicThrottling", ["dynamicThrottlingEnabled"]);
        _quotaLimit = DefineModelProperty<ServiceAccountQuotaLimit>("QuotaLimit", ["quotaLimit"], isOutput: true);
        _restrictOutboundNetworkAccess = DefineProperty<bool>("RestrictOutboundNetworkAccess", ["restrictOutboundNetworkAccess"]);
        _allowedFqdnList = DefineListProperty<string>("AllowedFqdnList", ["allowedFqdnList"]);
        _disableLocalAuth = DefineProperty<bool>("DisableLocalAuth", ["disableLocalAuth"]);
        _endpoints = DefineDictionaryProperty<string>("Endpoints", ["endpoints"], isOutput: true);
        _restore = DefineProperty<bool>("Restore", ["restore"]);
        _deletedOn = DefineProperty<DateTimeOffset>("DeletedOn", ["deletionDate"], isOutput: true);
        _scheduledPurgeDate = DefineProperty<string>("ScheduledPurgeDate", ["scheduledPurgeDate"], isOutput: true);
        _locations = DefineModelProperty<CognitiveServicesMultiRegionSettings>("Locations", ["locations"]);
        _commitmentPlanAssociations = DefineListProperty<CommitmentPlanAssociation>("CommitmentPlanAssociations", ["commitmentPlanAssociations"], isOutput: true);
        _abusePenalty = DefineModelProperty<AbusePenalty>("AbusePenalty", ["abusePenalty"], isOutput: true);
    }
}
