// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties of Cognitive Services account deployment model.
/// </summary>
public partial class CognitiveServicesAccountDeploymentScaleSettings : ProvisionableConstruct
{
    /// <summary>
    /// Deployment scale type.
    /// </summary>
    public BicepValue<CognitiveServicesAccountDeploymentScaleType> ScaleType 
    {
        get { Initialize(); return _scaleType!; }
        set { Initialize(); _scaleType!.Assign(value); }
    }
    private BicepValue<CognitiveServicesAccountDeploymentScaleType>? _scaleType;

    /// <summary>
    /// Deployment capacity.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Deployment active capacity. This value might be different from
    /// `capacity` if customer recently updated `capacity`.
    /// </summary>
    public BicepValue<int> ActiveCapacity 
    {
        get { Initialize(); return _activeCapacity!; }
    }
    private BicepValue<int>? _activeCapacity;

    /// <summary>
    /// Creates a new CognitiveServicesAccountDeploymentScaleSettings.
    /// </summary>
    public CognitiveServicesAccountDeploymentScaleSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesAccountDeploymentScaleSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _scaleType = DefineProperty<CognitiveServicesAccountDeploymentScaleType>("ScaleType", ["scaleType"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
        _activeCapacity = DefineProperty<int>("ActiveCapacity", ["activeCapacity"], isOutput: true);
    }
}
