// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties of Cognitive Services account deployment.
/// </summary>
public partial class CognitiveServicesAccountDeploymentProperties : ProvisionableConstruct
{
    /// <summary>
    /// Gets the status of the resource at the time the operation was called.
    /// </summary>
    public BicepValue<CognitiveServicesAccountDeploymentProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<CognitiveServicesAccountDeploymentProvisioningState>? _provisioningState;

    /// <summary>
    /// Properties of Cognitive Services account deployment model.
    /// </summary>
    public CognitiveServicesAccountDeploymentModel Model 
    {
        get { Initialize(); return _model!; }
        set { Initialize(); AssignOrReplace(ref _model, value); }
    }
    private CognitiveServicesAccountDeploymentModel? _model;

    /// <summary>
    /// Properties of Cognitive Services account deployment model.
    /// </summary>
    public CognitiveServicesAccountDeploymentScaleSettings ScaleSettings 
    {
        get { Initialize(); return _scaleSettings!; }
        set { Initialize(); AssignOrReplace(ref _scaleSettings, value); }
    }
    private CognitiveServicesAccountDeploymentScaleSettings? _scaleSettings;

    /// <summary>
    /// The capabilities.
    /// </summary>
    public BicepDictionary<string> Capabilities 
    {
        get { Initialize(); return _capabilities!; }
    }
    private BicepDictionary<string>? _capabilities;

    /// <summary>
    /// The name of RAI policy.
    /// </summary>
    public BicepValue<string> RaiPolicyName 
    {
        get { Initialize(); return _raiPolicyName!; }
        set { Initialize(); _raiPolicyName!.Assign(value); }
    }
    private BicepValue<string>? _raiPolicyName;

    /// <summary>
    /// The call rate limit Cognitive Services account.
    /// </summary>
    public ServiceAccountCallRateLimit CallRateLimit 
    {
        get { Initialize(); return _callRateLimit!; }
    }
    private ServiceAccountCallRateLimit? _callRateLimit;

    /// <summary>
    /// Gets the rate limits.
    /// </summary>
    public BicepList<ServiceAccountThrottlingRule> RateLimits 
    {
        get { Initialize(); return _rateLimits!; }
    }
    private BicepList<ServiceAccountThrottlingRule>? _rateLimits;

    /// <summary>
    /// Deployment model version upgrade option.
    /// </summary>
    public BicepValue<DeploymentModelVersionUpgradeOption> VersionUpgradeOption 
    {
        get { Initialize(); return _versionUpgradeOption!; }
        set { Initialize(); _versionUpgradeOption!.Assign(value); }
    }
    private BicepValue<DeploymentModelVersionUpgradeOption>? _versionUpgradeOption;

    /// <summary>
    /// Creates a new CognitiveServicesAccountDeploymentProperties.
    /// </summary>
    public CognitiveServicesAccountDeploymentProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesAccountDeploymentProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<CognitiveServicesAccountDeploymentProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _model = DefineModelProperty<CognitiveServicesAccountDeploymentModel>("Model", ["model"]);
        _scaleSettings = DefineModelProperty<CognitiveServicesAccountDeploymentScaleSettings>("ScaleSettings", ["scaleSettings"]);
        _capabilities = DefineDictionaryProperty<string>("Capabilities", ["capabilities"], isOutput: true);
        _raiPolicyName = DefineProperty<string>("RaiPolicyName", ["raiPolicyName"]);
        _callRateLimit = DefineModelProperty<ServiceAccountCallRateLimit>("CallRateLimit", ["callRateLimit"], isOutput: true);
        _rateLimits = DefineListProperty<ServiceAccountThrottlingRule>("RateLimits", ["rateLimits"], isOutput: true);
        _versionUpgradeOption = DefineProperty<DeploymentModelVersionUpgradeOption>("VersionUpgradeOption", ["versionUpgradeOption"]);
    }
}
