// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Properties of Cognitive Services account deployment model.
/// </summary>
public partial class CognitiveServicesAccountDeploymentModel : ProvisionableConstruct
{
    /// <summary>
    /// Deployment model format.
    /// </summary>
    public BicepValue<string> Format 
    {
        get { Initialize(); return _format!; }
        set { Initialize(); _format!.Assign(value); }
    }
    private BicepValue<string>? _format;

    /// <summary>
    /// Deployment model name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Optional. Deployment model version. If version is not specified, a
    /// default version will be assigned. The default version is different for
    /// different models and might change when there is new version available
    /// for a model. Default version for a model could be found from list
    /// models API.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Optional. Deployment model source ARM resource ID.
    /// </summary>
    public BicepValue<string> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<string>? _source;

    /// <summary>
    /// The call rate limit Cognitive Services account.
    /// </summary>
    public ServiceAccountCallRateLimit CallRateLimit 
    {
        get { Initialize(); return _callRateLimit!; }
    }
    private ServiceAccountCallRateLimit? _callRateLimit;

    /// <summary>
    /// Creates a new CognitiveServicesAccountDeploymentModel.
    /// </summary>
    public CognitiveServicesAccountDeploymentModel()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CognitiveServicesAccountDeploymentModel.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _format = DefineProperty<string>("Format", ["format"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _version = DefineProperty<string>("Version", ["version"]);
        _source = DefineProperty<string>("Source", ["source"]);
        _callRateLimit = DefineModelProperty<ServiceAccountCallRateLimit>("CallRateLimit", ["callRateLimit"], isOutput: true);
    }
}
