// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// The abuse penalty.
/// </summary>
public partial class AbusePenalty : ProvisionableConstruct
{
    /// <summary>
    /// The action of AbusePenalty.
    /// </summary>
    public BicepValue<AbusePenaltyAction> Action 
    {
        get { Initialize(); return _action!; }
    }
    private BicepValue<AbusePenaltyAction>? _action;

    /// <summary>
    /// The percentage of rate limit.
    /// </summary>
    public BicepValue<float> RateLimitPercentage 
    {
        get { Initialize(); return _rateLimitPercentage!; }
    }
    private BicepValue<float>? _rateLimitPercentage;

    /// <summary>
    /// The datetime of expiration of the AbusePenalty.
    /// </summary>
    public BicepValue<DateTimeOffset> Expiration 
    {
        get { Initialize(); return _expiration!; }
    }
    private BicepValue<DateTimeOffset>? _expiration;

    /// <summary>
    /// Creates a new AbusePenalty.
    /// </summary>
    public AbusePenalty()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AbusePenalty.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _action = DefineProperty<AbusePenaltyAction>("Action", ["action"], isOutput: true);
        _rateLimitPercentage = DefineProperty<float>("RateLimitPercentage", ["rateLimitPercentage"], isOutput: true);
        _expiration = DefineProperty<DateTimeOffset>("Expiration", ["expiration"], isOutput: true);
    }
}
