// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.CognitiveServices;

/// <summary>
/// Built-in CognitiveServices roles that you can assign to users, groups,
/// service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct CognitiveServicesBuiltInRole(string value) : IEquatable<CognitiveServicesBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Can perform all actions within an Azure AI resource besides managing
    /// the resource itself.
    /// </summary>
    public static CognitiveServicesBuiltInRole AzureAIDeveloper { get; } = new(AzureAIDeveloperValue);
    internal const string AzureAIDeveloperValue = "64702f94-c441-49e6-a78b-ef80e0188fee";

    /// <summary>
    /// Can approve private endpoint connections to Azure AI common dependency
    /// resources
    /// </summary>
    public static CognitiveServicesBuiltInRole AzureAIEnterpriseNetworkConnectionApprover { get; } = new(AzureAIEnterpriseNetworkConnectionApproverValue);
    internal const string AzureAIEnterpriseNetworkConnectionApproverValue = "b556d68e-0be0-4f35-a333-ad7ee1ce17ea";

    /// <summary>
    /// Can perform all actions required to create a resource deployment within
    /// a resource group.
    /// </summary>
    public static CognitiveServicesBuiltInRole AzureAIInferenceDeploymentOperator { get; } = new(AzureAIInferenceDeploymentOperatorValue);
    internal const string AzureAIInferenceDeploymentOperatorValue = "3afb7f49-54cb-416e-8c09-6dc049efa503";

    /// <summary>
    /// Lets you create, read, update, delete and manage keys of Cognitive
    /// Services.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesContributor { get; } = new(CognitiveServicesContributorValue);
    internal const string CognitiveServicesContributorValue = "25fbc0a9-bd7c-42a3-aa1a-3b75d497ee68";

    /// <summary>
    /// Full access to the project, including the ability to view, create,
    /// edit, or delete projects.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesCustomVisionContributor { get; } = new(CognitiveServicesCustomVisionContributorValue);
    internal const string CognitiveServicesCustomVisionContributorValue = "c1ff6cc2-c111-46fe-8896-e0ef812ad9f3";

    /// <summary>
    /// Publish, unpublish or export models. Deployment can view the project
    /// but can&apos;t update.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesCustomVisionDeployment { get; } = new(CognitiveServicesCustomVisionDeploymentValue);
    internal const string CognitiveServicesCustomVisionDeploymentValue = "5c4089e1-6d96-4d2f-b296-c1bc7137275f";

    /// <summary>
    /// View, edit training images and create, add, remove, or delete the image
    /// tags. Labelers can view the project but can&apos;t update anything
    /// other than training images and tags.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesCustomVisionLabeler { get; } = new(CognitiveServicesCustomVisionLabelerValue);
    internal const string CognitiveServicesCustomVisionLabelerValue = "88424f51-ebe7-446f-bc41-7fa16989e96c";

    /// <summary>
    /// Read-only actions in the project. Readers can&apos;t create or update
    /// the project.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesCustomVisionReader { get; } = new(CognitiveServicesCustomVisionReaderValue);
    internal const string CognitiveServicesCustomVisionReaderValue = "93586559-c37d-4a6b-ba08-b9f0940c2d73";

    /// <summary>
    /// View, edit projects and train the models, including the ability to
    /// publish, unpublish, export the models. Trainers can&apos;t create or
    /// delete the project.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesCustomVisionTrainer { get; } = new(CognitiveServicesCustomVisionTrainerValue);
    internal const string CognitiveServicesCustomVisionTrainerValue = "0a5ae4ab-0d65-4eeb-be61-29fc9b54394b";

    /// <summary>
    /// Lets you read Cognitive Services data.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesDataReader { get; } = new(CognitiveServicesDataReaderValue);
    internal const string CognitiveServicesDataReaderValue = "b59867f0-fa02-499b-be73-45a86b5b3e1c";

    /// <summary>
    /// Lets you perform detect, verify, identify, group, and find similar
    /// operations on Face API. This role does not allow create or delete
    /// operations, which makes it well suited for endpoints that only need
    /// inferencing capabilities, following &apos;least privilege&apos; best
    /// practices.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesFaceRecognizer { get; } = new(CognitiveServicesFaceRecognizerValue);
    internal const string CognitiveServicesFaceRecognizerValue = "9894cab4-e18a-44aa-828b-cb588cd6f2d7";

    /// <summary>
    /// Full access to the project, including the system level configuration.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesMetricsAdvisorAdministrator { get; } = new(CognitiveServicesMetricsAdvisorAdministratorValue);
    internal const string CognitiveServicesMetricsAdvisorAdministratorValue = "cb43c632-a144-4ec5-977c-e80c4affc34a";

    /// <summary>
    /// Full access including the ability to fine-tune, deploy and generate text
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesOpenAIContributor { get; } = new(CognitiveServicesOpenAIContributorValue);
    internal const string CognitiveServicesOpenAIContributorValue = "a001fd3d-188f-4b5d-821b-7da978bf7442";

    /// <summary>
    /// Read access to view files, models, deployments. The ability to create
    /// completion and embedding calls.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesOpenAIUser { get; } = new(CognitiveServicesOpenAIUserValue);
    internal const string CognitiveServicesOpenAIUserValue = "5e0bd9bd-7b93-4f28-af87-19fc36ad61bd";

    /// <summary>
    /// Let&apos;s you create, edit, import and export a KB. You cannot publish
    /// or delete a KB.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesQnAMakerEditor { get; } = new(CognitiveServicesQnAMakerEditorValue);
    internal const string CognitiveServicesQnAMakerEditorValue = "f4cc2bf9-21be-47a1-bdf1-5c5804381025";

    /// <summary>
    /// Let&apos;s you read and test a KB only.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesQnAMakerReader { get; } = new(CognitiveServicesQnAMakerReaderValue);
    internal const string CognitiveServicesQnAMakerReaderValue = "466ccd10-b268-4a11-b098-b4849f024126";

    /// <summary>
    /// Minimal permission to view Cognitive Services usages.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesUsagesReader { get; } = new(CognitiveServicesUsagesReaderValue);
    internal const string CognitiveServicesUsagesReaderValue = "bba48692-92b0-4667-a9ad-c31c7b334ac2";

    /// <summary>
    /// Lets you read and list keys of Cognitive Services.
    /// </summary>
    public static CognitiveServicesBuiltInRole CognitiveServicesUser { get; } = new(CognitiveServicesUserValue);
    internal const string CognitiveServicesUserValue = "a97b65f3-24c7-4388-baec-2e87135dc908";

    /// <summary>
    /// Try to get the name of a built-in CognitiveServices role from its ID
    /// value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in CognitiveServices role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(CognitiveServicesBuiltInRole value) =>
        value._value switch
        {
            AzureAIDeveloperValue => nameof(AzureAIDeveloper),
            AzureAIEnterpriseNetworkConnectionApproverValue => nameof(AzureAIEnterpriseNetworkConnectionApprover),
            AzureAIInferenceDeploymentOperatorValue => nameof(AzureAIInferenceDeploymentOperator),
            CognitiveServicesContributorValue => nameof(CognitiveServicesContributor),
            CognitiveServicesCustomVisionContributorValue => nameof(CognitiveServicesCustomVisionContributor),
            CognitiveServicesCustomVisionDeploymentValue => nameof(CognitiveServicesCustomVisionDeployment),
            CognitiveServicesCustomVisionLabelerValue => nameof(CognitiveServicesCustomVisionLabeler),
            CognitiveServicesCustomVisionReaderValue => nameof(CognitiveServicesCustomVisionReader),
            CognitiveServicesCustomVisionTrainerValue => nameof(CognitiveServicesCustomVisionTrainer),
            CognitiveServicesDataReaderValue => nameof(CognitiveServicesDataReader),
            CognitiveServicesFaceRecognizerValue => nameof(CognitiveServicesFaceRecognizer),
            CognitiveServicesMetricsAdvisorAdministratorValue => nameof(CognitiveServicesMetricsAdvisorAdministrator),
            CognitiveServicesOpenAIContributorValue => nameof(CognitiveServicesOpenAIContributor),
            CognitiveServicesOpenAIUserValue => nameof(CognitiveServicesOpenAIUser),
            CognitiveServicesQnAMakerEditorValue => nameof(CognitiveServicesQnAMakerEditor),
            CognitiveServicesQnAMakerReaderValue => nameof(CognitiveServicesQnAMakerReader),
            CognitiveServicesUsagesReaderValue => nameof(CognitiveServicesUsagesReader),
            CognitiveServicesUserValue => nameof(CognitiveServicesUser),
            _ => value._value
        };

    /// <summary>
    /// Determines if two CognitiveServicesBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first CognitiveServicesBuiltInRole to compare.</param>
    /// <param name="right">The second CognitiveServicesBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(CognitiveServicesBuiltInRole left, CognitiveServicesBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two CognitiveServicesBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first CognitiveServicesBuiltInRole to compare.</param>
    /// <param name="right">The second CognitiveServicesBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(CognitiveServicesBuiltInRole left, CognitiveServicesBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a CognitiveServicesBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator CognitiveServicesBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is CognitiveServicesBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(CognitiveServicesBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
