// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// Localized template data and gallery information.
/// </summary>
public partial class WorkbookTemplateLocalizedGallery : ProvisionableConstruct
{
    /// <summary>
    /// Valid JSON object containing workbook template payload.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> TemplateData 
    {
        get { Initialize(); return _templateData!; }
        set { Initialize(); _templateData!.Assign(value); }
    }
    private BicepValue<BinaryData>? _templateData;

    /// <summary>
    /// Workbook galleries supported by the template.
    /// </summary>
    public BicepList<WorkbookTemplateGallery> Galleries 
    {
        get { Initialize(); return _galleries!; }
        set { Initialize(); _galleries!.Assign(value); }
    }
    private BicepList<WorkbookTemplateGallery>? _galleries;

    /// <summary>
    /// Creates a new WorkbookTemplateLocalizedGallery.
    /// </summary>
    public WorkbookTemplateLocalizedGallery()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// WorkbookTemplateLocalizedGallery.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _templateData = DefineProperty<BinaryData>("TemplateData", ["templateData"]);
        _galleries = DefineListProperty<WorkbookTemplateGallery>("Galleries", ["galleries"]);
    }
}
