// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// Gallery information for a workbook template.
/// </summary>
public partial class WorkbookTemplateGallery : ProvisionableConstruct
{
    /// <summary>
    /// Name of the workbook template in the gallery.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Category for the gallery.
    /// </summary>
    public BicepValue<string> Category 
    {
        get { Initialize(); return _category!; }
        set { Initialize(); _category!.Assign(value); }
    }
    private BicepValue<string>? _category;

    /// <summary>
    /// Type of workbook supported by the workbook template.
    /// </summary>
    public BicepValue<string> WorkbookType 
    {
        get { Initialize(); return _workbookType!; }
        set { Initialize(); _workbookType!.Assign(value); }
    }
    private BicepValue<string>? _workbookType;

    /// <summary>
    /// Order of the template within the gallery.
    /// </summary>
    public BicepValue<int> Order 
    {
        get { Initialize(); return _order!; }
        set { Initialize(); _order!.Assign(value); }
    }
    private BicepValue<int>? _order;

    /// <summary>
    /// Azure resource type supported by the gallery.
    /// </summary>
    public BicepValue<string> ResourceType 
    {
        get { Initialize(); return _resourceType!; }
        set { Initialize(); _resourceType!.Assign(value); }
    }
    private BicepValue<string>? _resourceType;

    /// <summary>
    /// Creates a new WorkbookTemplateGallery.
    /// </summary>
    public WorkbookTemplateGallery()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WorkbookTemplateGallery.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _category = DefineProperty<string>("Category", ["category"]);
        _workbookType = DefineProperty<string>("WorkbookType", ["type"]);
        _order = DefineProperty<int>("Order", ["order"]);
        _resourceType = DefineProperty<string>("ResourceType", ["resourceType"]);
    }
}
