// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// The collection of validation rule properties.
/// </summary>
public partial class WebTestValidationRules : ProvisionableConstruct
{
    /// <summary>
    /// The collection of content validation properties.
    /// </summary>
    public WebTestContentValidation ContentValidation 
    {
        get { Initialize(); return _contentValidation!; }
        set { Initialize(); AssignOrReplace(ref _contentValidation, value); }
    }
    private WebTestContentValidation? _contentValidation;

    /// <summary>
    /// Checks to see if the SSL cert is still valid.
    /// </summary>
    public BicepValue<bool> CheckSsl 
    {
        get { Initialize(); return _checkSsl!; }
        set { Initialize(); _checkSsl!.Assign(value); }
    }
    private BicepValue<bool>? _checkSsl;

    /// <summary>
    /// A number of days to check still remain before the the existing SSL cert
    /// expires.  Value must be positive and the SSLCheck must be set to true.
    /// </summary>
    public BicepValue<int> SslCertRemainingLifetimeCheck 
    {
        get { Initialize(); return _sslCertRemainingLifetimeCheck!; }
        set { Initialize(); _sslCertRemainingLifetimeCheck!.Assign(value); }
    }
    private BicepValue<int>? _sslCertRemainingLifetimeCheck;

    /// <summary>
    /// Validate that the WebTest returns the http status code provided.
    /// </summary>
    public BicepValue<int> ExpectedHttpStatusCode 
    {
        get { Initialize(); return _expectedHttpStatusCode!; }
        set { Initialize(); _expectedHttpStatusCode!.Assign(value); }
    }
    private BicepValue<int>? _expectedHttpStatusCode;

    /// <summary>
    /// When set, validation will ignore the status code.
    /// </summary>
    public BicepValue<bool> IgnoreHttpStatusCode 
    {
        get { Initialize(); return _ignoreHttpStatusCode!; }
        set { Initialize(); _ignoreHttpStatusCode!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreHttpStatusCode;

    /// <summary>
    /// Creates a new WebTestValidationRules.
    /// </summary>
    public WebTestValidationRules()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebTestValidationRules.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _contentValidation = DefineModelProperty<WebTestContentValidation>("ContentValidation", ["ContentValidation"]);
        _checkSsl = DefineProperty<bool>("CheckSsl", ["SSLCheck"]);
        _sslCertRemainingLifetimeCheck = DefineProperty<int>("SslCertRemainingLifetimeCheck", ["SSLCertRemainingLifetimeCheck"]);
        _expectedHttpStatusCode = DefineProperty<int>("ExpectedHttpStatusCode", ["ExpectedHttpStatusCode"]);
        _ignoreHttpStatusCode = DefineProperty<bool>("IgnoreHttpStatusCode", ["IgnoreHttpStatusCode"]);
    }
}
