// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// A header to add to the WebTest.
/// </summary>
public partial class WebTestRequestHeaderField : ProvisionableConstruct
{
    /// <summary>
    /// The name of the header.
    /// </summary>
    public BicepValue<string> HeaderFieldName 
    {
        get { Initialize(); return _headerFieldName!; }
        set { Initialize(); _headerFieldName!.Assign(value); }
    }
    private BicepValue<string>? _headerFieldName;

    /// <summary>
    /// The value of the header.
    /// </summary>
    public BicepValue<string> HeaderFieldValue 
    {
        get { Initialize(); return _headerFieldValue!; }
        set { Initialize(); _headerFieldValue!.Assign(value); }
    }
    private BicepValue<string>? _headerFieldValue;

    /// <summary>
    /// Creates a new WebTestRequestHeaderField.
    /// </summary>
    public WebTestRequestHeaderField()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebTestRequestHeaderField.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _headerFieldName = DefineProperty<string>("HeaderFieldName", ["key"]);
        _headerFieldValue = DefineProperty<string>("HeaderFieldValue", ["value"]);
    }
}
