// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// The collection of request properties.
/// </summary>
public partial class WebTestRequest : ProvisionableConstruct
{
    /// <summary>
    /// Url location to test.
    /// </summary>
    public BicepValue<Uri> RequestUri 
    {
        get { Initialize(); return _requestUri!; }
        set { Initialize(); _requestUri!.Assign(value); }
    }
    private BicepValue<Uri>? _requestUri;

    /// <summary>
    /// List of headers and their values to add to the WebTest call.
    /// </summary>
    public BicepList<WebTestRequestHeaderField> Headers 
    {
        get { Initialize(); return _headers!; }
        set { Initialize(); _headers!.Assign(value); }
    }
    private BicepList<WebTestRequestHeaderField>? _headers;

    /// <summary>
    /// Http verb to use for this web test.
    /// </summary>
    public BicepValue<string> HttpVerb 
    {
        get { Initialize(); return _httpVerb!; }
        set { Initialize(); _httpVerb!.Assign(value); }
    }
    private BicepValue<string>? _httpVerb;

    /// <summary>
    /// Base64 encoded string body to send with this web test.
    /// </summary>
    public BicepValue<string> RequestBody 
    {
        get { Initialize(); return _requestBody!; }
        set { Initialize(); _requestBody!.Assign(value); }
    }
    private BicepValue<string>? _requestBody;

    /// <summary>
    /// Parse Dependent request for this WebTest.
    /// </summary>
    public BicepValue<bool> ParseDependentRequests 
    {
        get { Initialize(); return _parseDependentRequests!; }
        set { Initialize(); _parseDependentRequests!.Assign(value); }
    }
    private BicepValue<bool>? _parseDependentRequests;

    /// <summary>
    /// Follow redirects for this web test.
    /// </summary>
    public BicepValue<bool> FollowRedirects 
    {
        get { Initialize(); return _followRedirects!; }
        set { Initialize(); _followRedirects!.Assign(value); }
    }
    private BicepValue<bool>? _followRedirects;

    /// <summary>
    /// Creates a new WebTestRequest.
    /// </summary>
    public WebTestRequest()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebTestRequest.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _requestUri = DefineProperty<Uri>("RequestUri", ["RequestUrl"]);
        _headers = DefineListProperty<WebTestRequestHeaderField>("Headers", ["Headers"]);
        _httpVerb = DefineProperty<string>("HttpVerb", ["HttpVerb"]);
        _requestBody = DefineProperty<string>("RequestBody", ["RequestBody"]);
        _parseDependentRequests = DefineProperty<bool>("ParseDependentRequests", ["ParseDependentRequests"]);
        _followRedirects = DefineProperty<bool>("FollowRedirects", ["FollowRedirects"]);
    }
}
