// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// Geo-physical location to run a WebTest from. You must specify one or more
/// locations for the test to run from.
/// </summary>
public partial class WebTestGeolocation : ProvisionableConstruct
{
    /// <summary>
    /// Location ID for the WebTest to run from.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Creates a new WebTestGeolocation.
    /// </summary>
    public WebTestGeolocation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebTestGeolocation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["Id"]);
    }
}
