// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// The collection of content validation properties.
/// </summary>
public partial class WebTestContentValidation : ProvisionableConstruct
{
    /// <summary>
    /// Content to look for in the return of the WebTest.  Must not be null or
    /// empty.
    /// </summary>
    public BicepValue<string> ContentMatch 
    {
        get { Initialize(); return _contentMatch!; }
        set { Initialize(); _contentMatch!.Assign(value); }
    }
    private BicepValue<string>? _contentMatch;

    /// <summary>
    /// When set, this value makes the ContentMatch validation case insensitive.
    /// </summary>
    public BicepValue<bool> IgnoreCase 
    {
        get { Initialize(); return _ignoreCase!; }
        set { Initialize(); _ignoreCase!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreCase;

    /// <summary>
    /// When true, validation will pass if there is a match for the
    /// ContentMatch string.  If false, validation will fail if there is a
    /// match.
    /// </summary>
    public BicepValue<bool> PassIfTextFound 
    {
        get { Initialize(); return _passIfTextFound!; }
        set { Initialize(); _passIfTextFound!.Assign(value); }
    }
    private BicepValue<bool>? _passIfTextFound;

    /// <summary>
    /// Creates a new WebTestContentValidation.
    /// </summary>
    public WebTestContentValidation()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebTestContentValidation.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _contentMatch = DefineProperty<string>("ContentMatch", ["ContentMatch"]);
        _ignoreCase = DefineProperty<bool>("IgnoreCase", ["IgnoreCase"]);
        _passIfTextFound = DefineProperty<bool>("PassIfTextFound", ["PassIfTextFound"]);
    }
}
