// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// ApplicationInsightsWorkbookTemplate.
/// </summary>
public partial class ApplicationInsightsWorkbookTemplate : ProvisionableResource
{
    /// <summary>
    /// The name of the Application Insights component resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Information about the author of the workbook template.
    /// </summary>
    public BicepValue<string> Author 
    {
        get { Initialize(); return _author!; }
        set { Initialize(); _author!.Assign(value); }
    }
    private BicepValue<string>? _author;

    /// <summary>
    /// Workbook galleries supported by the template.
    /// </summary>
    public BicepList<WorkbookTemplateGallery> Galleries 
    {
        get { Initialize(); return _galleries!; }
        set { Initialize(); _galleries!.Assign(value); }
    }
    private BicepList<WorkbookTemplateGallery>? _galleries;

    /// <summary>
    /// Key value pair of localized gallery. Each key is the locale code of
    /// languages supported by the Azure portal.
    /// </summary>
    public BicepDictionary<BicepList<WorkbookTemplateLocalizedGallery>> LocalizedGalleries 
    {
        get { Initialize(); return _localizedGalleries!; }
        set { Initialize(); _localizedGalleries!.Assign(value); }
    }
    private BicepDictionary<BicepList<WorkbookTemplateLocalizedGallery>>? _localizedGalleries;

    /// <summary>
    /// Priority of the template. Determines which template to open when a
    /// workbook gallery is opened in viewer mode.
    /// </summary>
    public BicepValue<int> Priority 
    {
        get { Initialize(); return _priority!; }
        set { Initialize(); _priority!.Assign(value); }
    }
    private BicepValue<int>? _priority;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Valid JSON object containing workbook template payload.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> TemplateData 
    {
        get { Initialize(); return _templateData!; }
        set { Initialize(); _templateData!.Assign(value); }
    }
    private BicepValue<BinaryData>? _templateData;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ApplicationInsightsWorkbookTemplate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ApplicationInsightsWorkbookTemplate resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ApplicationInsightsWorkbookTemplate.</param>
    public ApplicationInsightsWorkbookTemplate(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Insights/workbooktemplates", resourceVersion ?? "2020-11-20")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ApplicationInsightsWorkbookTemplate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _author = DefineProperty<string>("Author", ["properties", "author"]);
        _galleries = DefineListProperty<WorkbookTemplateGallery>("Galleries", ["properties", "galleries"]);
        _localizedGalleries = DefineDictionaryProperty<BicepList<WorkbookTemplateLocalizedGallery>>("LocalizedGalleries", ["properties", "localized"]);
        _priority = DefineProperty<int>("Priority", ["properties", "priority"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _templateData = DefineProperty<BinaryData>("TemplateData", ["properties", "templateData"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ApplicationInsightsWorkbookTemplate resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2020-11-20.
        /// </summary>
        public static readonly string V2020_11_20 = "2020-11-20";
    }

    /// <summary>
    /// Creates a reference to an existing ApplicationInsightsWorkbookTemplate.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ApplicationInsightsWorkbookTemplate resource.  This can be used to
    /// refer to the resource in expressions, but is not the Azure name of the
    /// resource.  This value can contain letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ApplicationInsightsWorkbookTemplate.</param>
    /// <returns>The existing ApplicationInsightsWorkbookTemplate resource.</returns>
    public static ApplicationInsightsWorkbookTemplate FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
