// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// ApplicationInsightsWebTest.
/// </summary>
public partial class ApplicationInsightsWebTest : ProvisionableResource
{
    /// <summary>
    /// The name of the Application Insights WebTest resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// User defined description for this WebTest.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Interval in seconds between test runs for this WebTest. Default value
    /// is 300.
    /// </summary>
    public BicepValue<int> FrequencyInSeconds 
    {
        get { Initialize(); return _frequencyInSeconds!; }
        set { Initialize(); _frequencyInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _frequencyInSeconds;

    /// <summary>
    /// Is the test actively being monitored.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Allow for retries should this WebTest fail.
    /// </summary>
    public BicepValue<bool> IsRetryEnabled 
    {
        get { Initialize(); return _isRetryEnabled!; }
        set { Initialize(); _isRetryEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRetryEnabled;

    /// <summary>
    /// The kind of WebTest that this web test watches. Choices are ping,
    /// multistep and standard.
    /// </summary>
    public BicepValue<WebTestKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<WebTestKind>? _kind;

    /// <summary>
    /// A list of where to physically run the tests from to give global
    /// coverage for accessibility of your application.
    /// </summary>
    public BicepList<WebTestGeolocation> Locations 
    {
        get { Initialize(); return _locations!; }
        set { Initialize(); _locations!.Assign(value); }
    }
    private BicepList<WebTestGeolocation>? _locations;

    /// <summary>
    /// The collection of request properties.
    /// </summary>
    public WebTestRequest Request 
    {
        get { Initialize(); return _request!; }
        set { Initialize(); AssignOrReplace(ref _request, value); }
    }
    private WebTestRequest? _request;

    /// <summary>
    /// Unique ID of this WebTest. This is typically the same value as the Name
    /// field.
    /// </summary>
    public BicepValue<string> SyntheticMonitorId 
    {
        get { Initialize(); return _syntheticMonitorId!; }
        set { Initialize(); _syntheticMonitorId!.Assign(value); }
    }
    private BicepValue<string>? _syntheticMonitorId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Seconds until this WebTest will timeout and fail. Default value is 30.
    /// </summary>
    public BicepValue<int> TimeoutInSeconds 
    {
        get { Initialize(); return _timeoutInSeconds!; }
        set { Initialize(); _timeoutInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _timeoutInSeconds;

    /// <summary>
    /// The collection of validation rule properties.
    /// </summary>
    public WebTestValidationRules ValidationRules 
    {
        get { Initialize(); return _validationRules!; }
        set { Initialize(); AssignOrReplace(ref _validationRules, value); }
    }
    private WebTestValidationRules? _validationRules;

    /// <summary>
    /// The XML specification of a WebTest to run against an application.
    /// </summary>
    public BicepValue<string> WebTest 
    {
        get { Initialize(); return _webTest!; }
        set { Initialize(); _webTest!.Assign(value); }
    }
    private BicepValue<string>? _webTest;

    /// <summary>
    /// The kind of web test this is, valid choices are ping, multistep and
    /// standard.
    /// </summary>
    public BicepValue<WebTestKind> WebTestKind 
    {
        get { Initialize(); return _webTestKind!; }
        set { Initialize(); _webTestKind!.Assign(value); }
    }
    private BicepValue<WebTestKind>? _webTestKind;

    /// <summary>
    /// User defined name if this WebTest.
    /// </summary>
    public BicepValue<string> WebTestName 
    {
        get { Initialize(); return _webTestName!; }
        set { Initialize(); _webTestName!.Assign(value); }
    }
    private BicepValue<string>? _webTestName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Current state of this component, whether or not is has been provisioned
    /// within the resource group it is defined. Users cannot change this
    /// value but are able to read from it. Values will include Succeeded,
    /// Deploying, Canceled, and Failed.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ApplicationInsightsWebTest.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ApplicationInsightsWebTest
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ApplicationInsightsWebTest.</param>
    public ApplicationInsightsWebTest(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Insights/webtests", resourceVersion ?? "2022-06-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ApplicationInsightsWebTest.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _description = DefineProperty<string>("Description", ["properties", "Description"]);
        _frequencyInSeconds = DefineProperty<int>("FrequencyInSeconds", ["properties", "Frequency"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["properties", "Enabled"]);
        _isRetryEnabled = DefineProperty<bool>("IsRetryEnabled", ["properties", "RetryEnabled"]);
        _kind = DefineProperty<WebTestKind>("Kind", ["kind"]);
        _locations = DefineListProperty<WebTestGeolocation>("Locations", ["properties", "Locations"]);
        _request = DefineModelProperty<WebTestRequest>("Request", ["properties", "Request"]);
        _syntheticMonitorId = DefineProperty<string>("SyntheticMonitorId", ["properties", "SyntheticMonitorId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _timeoutInSeconds = DefineProperty<int>("TimeoutInSeconds", ["properties", "Timeout"]);
        _validationRules = DefineModelProperty<WebTestValidationRules>("ValidationRules", ["properties", "ValidationRules"]);
        _webTest = DefineProperty<string>("WebTest", ["properties", "Configuration", "WebTest"]);
        _webTestKind = DefineProperty<WebTestKind>("WebTestKind", ["properties", "Kind"]);
        _webTestName = DefineProperty<string>("WebTestName", ["properties", "Name"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ApplicationInsightsWebTest resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2022-06-15.
        /// </summary>
        public static readonly string V2022_06_15 = "2022-06-15";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2014-08-01.
        /// </summary>
        public static readonly string V2014_08_01 = "2014-08-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing ApplicationInsightsWebTest.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ApplicationInsightsWebTest
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ApplicationInsightsWebTest.</param>
    /// <returns>The existing ApplicationInsightsWebTest resource.</returns>
    public static ApplicationInsightsWebTest FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
