// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.ApplicationInsights;

/// <summary>
/// Built-in ApplicationInsights roles that you can assign to users, groups,
/// service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct ApplicationInsightsBuiltInRole(string value) : IEquatable<ApplicationInsightsBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Can manage Application Insights components
    /// </summary>
    public static ApplicationInsightsBuiltInRole ApplicationInsightsComponentContributor { get; } = new(ApplicationInsightsComponentContributorValue);
    internal const string ApplicationInsightsComponentContributorValue = "ae349356-3a1b-4a5e-921d-050484c6347e";

    /// <summary>
    /// Gives user permission to view and download debug snapshots collected
    /// with the Application Insights Snapshot Debugger. Note that these
    /// permissions are not included in the Owner or Contributor roles. When
    /// giving users the Application Insights Snapshot Debugger role, you must
    /// grant the role directly to the user. The role is not recognized when
    /// it is added to a custom role.
    /// </summary>
    public static ApplicationInsightsBuiltInRole ApplicationInsightsSnapshotDebugger { get; } = new(ApplicationInsightsSnapshotDebuggerValue);
    internal const string ApplicationInsightsSnapshotDebuggerValue = "08954f03-6346-4c2e-81c0-ec3a5cfae23b";

    /// <summary>
    /// Can read all monitoring data and edit monitoring settings. See also Get
    /// started with roles, permissions, and security with Azure Monitor.
    /// </summary>
    public static ApplicationInsightsBuiltInRole MonitoringContributor { get; } = new(MonitoringContributorValue);
    internal const string MonitoringContributorValue = "749f88d5-cbae-40b8-bcfc-e573ddc772fa";

    /// <summary>
    /// Enables publishing metrics against Azure resources
    /// </summary>
    public static ApplicationInsightsBuiltInRole MonitoringMetricsPublisher { get; } = new(MonitoringMetricsPublisherValue);
    internal const string MonitoringMetricsPublisherValue = "3913510d-42f4-4e42-8a64-420c390055eb";

    /// <summary>
    /// Can read all monitoring data (metrics, logs, etc.). See also Get
    /// started with roles, permissions, and security with Azure Monitor.
    /// </summary>
    public static ApplicationInsightsBuiltInRole MonitoringReader { get; } = new(MonitoringReaderValue);
    internal const string MonitoringReaderValue = "43d0d8ad-25c7-4714-9337-8ba259a9fe05";

    /// <summary>
    /// Can save shared workbooks.
    /// </summary>
    public static ApplicationInsightsBuiltInRole WorkbookContributor { get; } = new(WorkbookContributorValue);
    internal const string WorkbookContributorValue = "e8ddcd69-c73f-4f9f-9844-4100522f16ad";

    /// <summary>
    /// Can read workbooks.
    /// </summary>
    public static ApplicationInsightsBuiltInRole WorkbookReader { get; } = new(WorkbookReaderValue);
    internal const string WorkbookReaderValue = "b279062a-9be3-42a0-92ae-8b3cf002ec4d";

    /// <summary>
    /// Try to get the name of a built-in ApplicationInsights role from its ID
    /// value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in ApplicationInsights role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(ApplicationInsightsBuiltInRole value) =>
        value._value switch
        {
            ApplicationInsightsComponentContributorValue => nameof(ApplicationInsightsComponentContributor),
            ApplicationInsightsSnapshotDebuggerValue => nameof(ApplicationInsightsSnapshotDebugger),
            MonitoringContributorValue => nameof(MonitoringContributor),
            MonitoringMetricsPublisherValue => nameof(MonitoringMetricsPublisher),
            MonitoringReaderValue => nameof(MonitoringReader),
            WorkbookContributorValue => nameof(WorkbookContributor),
            WorkbookReaderValue => nameof(WorkbookReader),
            _ => value._value
        };

    /// <summary>
    /// Determines if two ApplicationInsightsBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first ApplicationInsightsBuiltInRole to compare.</param>
    /// <param name="right">The second ApplicationInsightsBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(ApplicationInsightsBuiltInRole left, ApplicationInsightsBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two ApplicationInsightsBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first ApplicationInsightsBuiltInRole to compare.</param>
    /// <param name="right">The second ApplicationInsightsBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(ApplicationInsightsBuiltInRole left, ApplicationInsightsBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a ApplicationInsightsBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator ApplicationInsightsBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is ApplicationInsightsBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(ApplicationInsightsBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
