// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// WebSiteSlotExtension.
/// </summary>
public partial class WebSiteSlotExtension : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// List of authors.
    /// </summary>
    public BicepList<string> Authors 
    {
        get { Initialize(); return _authors!; }
    }
    private BicepList<string>? _authors;

    /// <summary>
    /// Site Extension comment.
    /// </summary>
    public BicepValue<string> Comment 
    {
        get { Initialize(); return _comment!; }
    }
    private BicepValue<string>? _comment;

    /// <summary>
    /// Detailed description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Count of downloads.
    /// </summary>
    public BicepValue<int> DownloadCount 
    {
        get { Initialize(); return _downloadCount!; }
    }
    private BicepValue<int>? _downloadCount;

    /// <summary>
    /// Site extension ID.
    /// </summary>
    public BicepValue<string> ExtensionId 
    {
        get { Initialize(); return _extensionId!; }
    }
    private BicepValue<string>? _extensionId;

    /// <summary>
    /// Site extension type.
    /// </summary>
    public BicepValue<SiteExtensionType> ExtensionType 
    {
        get { Initialize(); return _extensionType!; }
    }
    private BicepValue<SiteExtensionType>? _extensionType;

    /// <summary>
    /// Extension URL.
    /// </summary>
    public BicepValue<Uri> ExtensionUri 
    {
        get { Initialize(); return _extensionUri!; }
    }
    private BicepValue<Uri>? _extensionUri;

    /// <summary>
    /// Feed URL.
    /// </summary>
    public BicepValue<Uri> FeedUri 
    {
        get { Initialize(); return _feedUri!; }
    }
    private BicepValue<Uri>? _feedUri;

    /// <summary>
    /// Icon URL.
    /// </summary>
    public BicepValue<Uri> IconUri 
    {
        get { Initialize(); return _iconUri!; }
    }
    private BicepValue<Uri>? _iconUri;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Installed timestamp.
    /// </summary>
    public BicepValue<DateTimeOffset> InstalledOn 
    {
        get { Initialize(); return _installedOn!; }
    }
    private BicepValue<DateTimeOffset>? _installedOn;

    /// <summary>
    /// Installer command line parameters.
    /// </summary>
    public BicepValue<string> InstallerCommandLineParams 
    {
        get { Initialize(); return _installerCommandLineParams!; }
    }
    private BicepValue<string>? _installerCommandLineParams;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// License URL.
    /// </summary>
    public BicepValue<Uri> LicenseUri 
    {
        get { Initialize(); return _licenseUri!; }
    }
    private BicepValue<Uri>? _licenseUri;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the local version is the latest
    /// version; &lt;code&gt;false&lt;/code&gt; otherwise.
    /// </summary>
    public BicepValue<bool> LocalIsLatestVersion 
    {
        get { Initialize(); return _localIsLatestVersion!; }
    }
    private BicepValue<bool>? _localIsLatestVersion;

    /// <summary>
    /// Local path.
    /// </summary>
    public BicepValue<string> LocalPath 
    {
        get { Initialize(); return _localPath!; }
    }
    private BicepValue<string>? _localPath;

    /// <summary>
    /// Project URL.
    /// </summary>
    public BicepValue<Uri> ProjectUri 
    {
        get { Initialize(); return _projectUri!; }
    }
    private BicepValue<Uri>? _projectUri;

    /// <summary>
    /// Provisioning state.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Published timestamp.
    /// </summary>
    public BicepValue<DateTimeOffset> PublishedOn 
    {
        get { Initialize(); return _publishedOn!; }
    }
    private BicepValue<DateTimeOffset>? _publishedOn;

    /// <summary>
    /// Summary description.
    /// </summary>
    public BicepValue<string> Summary 
    {
        get { Initialize(); return _summary!; }
    }
    private BicepValue<string>? _summary;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets the title.
    /// </summary>
    public BicepValue<string> Title 
    {
        get { Initialize(); return _title!; }
    }
    private BicepValue<string>? _title;

    /// <summary>
    /// Version information.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Gets or sets a reference to the parent WebSiteSlot.
    /// </summary>
    public WebSiteSlot? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSiteSlot>? _parent;

    /// <summary>
    /// Creates a new WebSiteSlotExtension.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebSiteSlotExtension resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebSiteSlotExtension.</param>
    public WebSiteSlotExtension(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/slots/siteextensions", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebSiteSlotExtension.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _authors = DefineListProperty<string>("Authors", ["properties", "authors"], isOutput: true);
        _comment = DefineProperty<string>("Comment", ["properties", "comment"], isOutput: true);
        _description = DefineProperty<string>("Description", ["properties", "description"], isOutput: true);
        _downloadCount = DefineProperty<int>("DownloadCount", ["properties", "download_count"], isOutput: true);
        _extensionId = DefineProperty<string>("ExtensionId", ["properties", "extension_id"], isOutput: true);
        _extensionType = DefineProperty<SiteExtensionType>("ExtensionType", ["properties", "extension_type"], isOutput: true);
        _extensionUri = DefineProperty<Uri>("ExtensionUri", ["properties", "extension_url"], isOutput: true);
        _feedUri = DefineProperty<Uri>("FeedUri", ["properties", "feed_url"], isOutput: true);
        _iconUri = DefineProperty<Uri>("IconUri", ["properties", "icon_url"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _installedOn = DefineProperty<DateTimeOffset>("InstalledOn", ["properties", "installed_date_time"], isOutput: true);
        _installerCommandLineParams = DefineProperty<string>("InstallerCommandLineParams", ["properties", "installer_command_line_params"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"], isOutput: true);
        _licenseUri = DefineProperty<Uri>("LicenseUri", ["properties", "license_url"], isOutput: true);
        _localIsLatestVersion = DefineProperty<bool>("LocalIsLatestVersion", ["properties", "local_is_latest_version"], isOutput: true);
        _localPath = DefineProperty<string>("LocalPath", ["properties", "local_path"], isOutput: true);
        _projectUri = DefineProperty<Uri>("ProjectUri", ["properties", "project_url"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _publishedOn = DefineProperty<DateTimeOffset>("PublishedOn", ["properties", "published_date_time"], isOutput: true);
        _summary = DefineProperty<string>("Summary", ["properties", "summary"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _title = DefineProperty<string>("Title", ["properties", "title"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
        _parent = DefineResource<WebSiteSlot>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported WebSiteSlotExtension resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing WebSiteSlotExtension.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebSiteSlotExtension resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebSiteSlotExtension.</param>
    /// <returns>The existing WebSiteSlotExtension resource.</returns>
    public static WebSiteSlotExtension FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
