// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// WebSiteSlotConfig.
/// </summary>
public partial class WebSiteSlotConfig : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// If using user managed identity, the user managed identity ClientId.
    /// </summary>
    public BicepValue<string> AcrUserManagedIdentityId 
    {
        get { Initialize(); return _acrUserManagedIdentityId!; }
        set { Initialize(); _acrUserManagedIdentityId!.Assign(value); }
    }
    private BicepValue<string>? _acrUserManagedIdentityId;

    /// <summary>
    /// IP security restrictions for scm to use main.
    /// </summary>
    public BicepValue<bool> AllowIPSecurityRestrictionsForScmToUseMain 
    {
        get { Initialize(); return _allowIPSecurityRestrictionsForScmToUseMain!; }
        set { Initialize(); _allowIPSecurityRestrictionsForScmToUseMain!.Assign(value); }
    }
    private BicepValue<bool>? _allowIPSecurityRestrictionsForScmToUseMain;

    /// <summary>
    /// The URL of the API definition.
    /// </summary>
    public BicepValue<Uri> ApiDefinitionUri 
    {
        get { Initialize(); return _apiDefinitionUri!; }
        set { Initialize(); _apiDefinitionUri!.Assign(value); }
    }
    private BicepValue<Uri>? _apiDefinitionUri;

    /// <summary>
    /// APIM-Api Identifier.
    /// </summary>
    public BicepValue<string> ApiManagementConfigId 
    {
        get { Initialize(); return _apiManagementConfigId!; }
        set { Initialize(); _apiManagementConfigId!.Assign(value); }
    }
    private BicepValue<string>? _apiManagementConfigId;

    /// <summary>
    /// App command line to launch.
    /// </summary>
    public BicepValue<string> AppCommandLine 
    {
        get { Initialize(); return _appCommandLine!; }
        set { Initialize(); _appCommandLine!.Assign(value); }
    }
    private BicepValue<string>? _appCommandLine;

    /// <summary>
    /// Application settings.
    /// </summary>
    public BicepList<AppServiceNameValuePair> AppSettings 
    {
        get { Initialize(); return _appSettings!; }
        set { Initialize(); _appSettings!.Assign(value); }
    }
    private BicepList<AppServiceNameValuePair>? _appSettings;

    /// <summary>
    /// Auto Heal rules.
    /// </summary>
    public AutoHealRules AutoHealRules 
    {
        get { Initialize(); return _autoHealRules!; }
        set { Initialize(); AssignOrReplace(ref _autoHealRules, value); }
    }
    private AutoHealRules? _autoHealRules;

    /// <summary>
    /// Auto-swap slot name.
    /// </summary>
    public BicepValue<string> AutoSwapSlotName 
    {
        get { Initialize(); return _autoSwapSlotName!; }
        set { Initialize(); _autoSwapSlotName!.Assign(value); }
    }
    private BicepValue<string>? _autoSwapSlotName;

    /// <summary>
    /// List of Azure Storage Accounts.
    /// </summary>
    public BicepDictionary<AppServiceStorageAccessInfo> AzureStorageAccounts 
    {
        get { Initialize(); return _azureStorageAccounts!; }
        set { Initialize(); _azureStorageAccounts!.Assign(value); }
    }
    private BicepDictionary<AppServiceStorageAccessInfo>? _azureStorageAccounts;

    /// <summary>
    /// Connection strings.
    /// </summary>
    public BicepList<ConnStringInfo> ConnectionStrings 
    {
        get { Initialize(); return _connectionStrings!; }
        set { Initialize(); _connectionStrings!.Assign(value); }
    }
    private BicepList<ConnStringInfo>? _connectionStrings;

    /// <summary>
    /// Cross-Origin Resource Sharing (CORS) settings.
    /// </summary>
    public AppServiceCorsSettings Cors 
    {
        get { Initialize(); return _cors!; }
        set { Initialize(); AssignOrReplace(ref _cors, value); }
    }
    private AppServiceCorsSettings? _cors;

    /// <summary>
    /// Default documents.
    /// </summary>
    public BicepList<string> DefaultDocuments 
    {
        get { Initialize(); return _defaultDocuments!; }
        set { Initialize(); _defaultDocuments!.Assign(value); }
    }
    private BicepList<string>? _defaultDocuments;

    /// <summary>
    /// Document root.
    /// </summary>
    public BicepValue<string> DocumentRoot 
    {
        get { Initialize(); return _documentRoot!; }
        set { Initialize(); _documentRoot!.Assign(value); }
    }
    private BicepValue<string>? _documentRoot;

    /// <summary>
    /// Maximum number of workers that a site can scale out to.
    /// This setting only applies to apps in plans where
    /// ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;
    /// </summary>
    public BicepValue<int> ElasticWebAppScaleLimit 
    {
        get { Initialize(); return _elasticWebAppScaleLimit!; }
        set { Initialize(); _elasticWebAppScaleLimit!.Assign(value); }
    }
    private BicepValue<int>? _elasticWebAppScaleLimit;

    /// <summary>
    /// List of ramp-up rules.
    /// </summary>
    public BicepList<RampUpRule> ExperimentsRampUpRules 
    {
        get { Initialize(); return _experimentsRampUpRules!; }
        set { Initialize(); _experimentsRampUpRules!.Assign(value); }
    }
    private BicepList<RampUpRule>? _experimentsRampUpRules;

    /// <summary>
    /// State of FTP / FTPS service.
    /// </summary>
    public BicepValue<AppServiceFtpsState> FtpsState 
    {
        get { Initialize(); return _ftpsState!; }
        set { Initialize(); _ftpsState!.Assign(value); }
    }
    private BicepValue<AppServiceFtpsState>? _ftpsState;

    /// <summary>
    /// Maximum number of workers that a site can scale out to.
    /// This setting only applies to the Consumption and Elastic
    /// Premium Plans
    /// </summary>
    public BicepValue<int> FunctionAppScaleLimit 
    {
        get { Initialize(); return _functionAppScaleLimit!; }
        set { Initialize(); _functionAppScaleLimit!.Assign(value); }
    }
    private BicepValue<int>? _functionAppScaleLimit;

    /// <summary>
    /// Handler mappings.
    /// </summary>
    public BicepList<HttpRequestHandlerMapping> HandlerMappings 
    {
        get { Initialize(); return _handlerMappings!; }
        set { Initialize(); _handlerMappings!.Assign(value); }
    }
    private BicepList<HttpRequestHandlerMapping>? _handlerMappings;

    /// <summary>
    /// Health check path.
    /// </summary>
    public BicepValue<string> HealthCheckPath 
    {
        get { Initialize(); return _healthCheckPath!; }
        set { Initialize(); _healthCheckPath!.Assign(value); }
    }
    private BicepValue<string>? _healthCheckPath;

    /// <summary>
    /// IP security restrictions for main.
    /// </summary>
    public BicepList<AppServiceIPSecurityRestriction> IPSecurityRestrictions 
    {
        get { Initialize(); return _iPSecurityRestrictions!; }
        set { Initialize(); _iPSecurityRestrictions!.Assign(value); }
    }
    private BicepList<AppServiceIPSecurityRestriction>? _iPSecurityRestrictions;

    /// <summary>
    /// Default action for main access restriction if no rules are matched.
    /// </summary>
    public BicepValue<SiteDefaultAction> IPSecurityRestrictionsDefaultAction 
    {
        get { Initialize(); return _iPSecurityRestrictionsDefaultAction!; }
        set { Initialize(); _iPSecurityRestrictionsDefaultAction!.Assign(value); }
    }
    private BicepValue<SiteDefaultAction>? _iPSecurityRestrictionsDefaultAction;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsAlwaysOn 
    {
        get { Initialize(); return _isAlwaysOn!; }
        set { Initialize(); _isAlwaysOn!.Assign(value); }
    }
    private BicepValue<bool>? _isAlwaysOn;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsAutoHealEnabled 
    {
        get { Initialize(); return _isAutoHealEnabled!; }
        set { Initialize(); _isAutoHealEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoHealEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
    /// otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsDetailedErrorLoggingEnabled 
    {
        get { Initialize(); return _isDetailedErrorLoggingEnabled!; }
        set { Initialize(); _isDetailedErrorLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isDetailedErrorLoggingEnabled;

    /// <summary>
    /// Gets or sets a value indicating whether functions runtime scale
    /// monitoring is enabled. When enabled,             the ScaleController
    /// will not monitor event sources directly, but will instead call to the
    /// runtime to get scale status.
    /// </summary>
    public BicepValue<bool> IsFunctionsRuntimeScaleMonitoringEnabled 
    {
        get { Initialize(); return _isFunctionsRuntimeScaleMonitoringEnabled!; }
        set { Initialize(); _isFunctionsRuntimeScaleMonitoringEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isFunctionsRuntimeScaleMonitoringEnabled;

    /// <summary>
    /// Http20Enabled: configures a web site to allow clients to connect over
    /// http2.0.
    /// </summary>
    public BicepValue<bool> IsHttp20Enabled 
    {
        get { Initialize(); return _isHttp20Enabled!; }
        set { Initialize(); _isHttp20Enabled!.Assign(value); }
    }
    private BicepValue<bool>? _isHttp20Enabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsHttpLoggingEnabled 
    {
        get { Initialize(); return _isHttpLoggingEnabled!; }
        set { Initialize(); _isHttpLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isHttpLoggingEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsLocalMySqlEnabled 
    {
        get { Initialize(); return _isLocalMySqlEnabled!; }
        set { Initialize(); _isLocalMySqlEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalMySqlEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled;
    /// otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsRemoteDebuggingEnabled 
    {
        get { Initialize(); return _isRemoteDebuggingEnabled!; }
        set { Initialize(); _isRemoteDebuggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRemoteDebuggingEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsRequestTracingEnabled 
    {
        get { Initialize(); return _isRequestTracingEnabled!; }
        set { Initialize(); _isRequestTracingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRequestTracingEnabled;

    /// <summary>
    /// Virtual Network Route All enabled. This causes all outbound traffic to
    /// have Virtual Network Security Groups and User Defined Routes applied.
    /// </summary>
    public BicepValue<bool> IsVnetRouteAllEnabled 
    {
        get { Initialize(); return _isVnetRouteAllEnabled!; }
        set { Initialize(); _isVnetRouteAllEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isVnetRouteAllEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsWebSocketsEnabled 
    {
        get { Initialize(); return _isWebSocketsEnabled!; }
        set { Initialize(); _isWebSocketsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isWebSocketsEnabled;

    /// <summary>
    /// Java container.
    /// </summary>
    public BicepValue<string> JavaContainer 
    {
        get { Initialize(); return _javaContainer!; }
        set { Initialize(); _javaContainer!.Assign(value); }
    }
    private BicepValue<string>? _javaContainer;

    /// <summary>
    /// Java container version.
    /// </summary>
    public BicepValue<string> JavaContainerVersion 
    {
        get { Initialize(); return _javaContainerVersion!; }
        set { Initialize(); _javaContainerVersion!.Assign(value); }
    }
    private BicepValue<string>? _javaContainerVersion;

    /// <summary>
    /// Java version.
    /// </summary>
    public BicepValue<string> JavaVersion 
    {
        get { Initialize(); return _javaVersion!; }
        set { Initialize(); _javaVersion!.Assign(value); }
    }
    private BicepValue<string>? _javaVersion;

    /// <summary>
    /// Identity to use for Key Vault Reference authentication.
    /// </summary>
    public BicepValue<string> KeyVaultReferenceIdentity 
    {
        get { Initialize(); return _keyVaultReferenceIdentity!; }
        set { Initialize(); _keyVaultReferenceIdentity!.Assign(value); }
    }
    private BicepValue<string>? _keyVaultReferenceIdentity;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Site limits.
    /// </summary>
    public SiteLimits Limits 
    {
        get { Initialize(); return _limits!; }
        set { Initialize(); AssignOrReplace(ref _limits, value); }
    }
    private SiteLimits? _limits;

    /// <summary>
    /// Linux App Framework and version.
    /// </summary>
    public BicepValue<string> LinuxFxVersion 
    {
        get { Initialize(); return _linuxFxVersion!; }
        set { Initialize(); _linuxFxVersion!.Assign(value); }
    }
    private BicepValue<string>? _linuxFxVersion;

    /// <summary>
    /// Site load balancing.
    /// </summary>
    public BicepValue<SiteLoadBalancing> LoadBalancing 
    {
        get { Initialize(); return _loadBalancing!; }
        set { Initialize(); _loadBalancing!.Assign(value); }
    }
    private BicepValue<SiteLoadBalancing>? _loadBalancing;

    /// <summary>
    /// HTTP logs directory size limit.
    /// </summary>
    public BicepValue<int> LogsDirectorySizeLimit 
    {
        get { Initialize(); return _logsDirectorySizeLimit!; }
        set { Initialize(); _logsDirectorySizeLimit!.Assign(value); }
    }
    private BicepValue<int>? _logsDirectorySizeLimit;

    /// <summary>
    /// Managed pipeline mode.
    /// </summary>
    public BicepValue<ManagedPipelineMode> ManagedPipelineMode 
    {
        get { Initialize(); return _managedPipelineMode!; }
        set { Initialize(); _managedPipelineMode!.Assign(value); }
    }
    private BicepValue<ManagedPipelineMode>? _managedPipelineMode;

    /// <summary>
    /// Managed Service Identity Id.
    /// </summary>
    public BicepValue<int> ManagedServiceIdentityId 
    {
        get { Initialize(); return _managedServiceIdentityId!; }
        set { Initialize(); _managedServiceIdentityId!.Assign(value); }
    }
    private BicepValue<int>? _managedServiceIdentityId;

    /// <summary>
    /// Application metadata. This property cannot be retrieved, since it may
    /// contain secrets.
    /// </summary>
    public BicepList<AppServiceNameValuePair> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepList<AppServiceNameValuePair>? _metadata;

    /// <summary>
    /// Number of minimum instance count for a site             This setting
    /// only applies to the Elastic Plans
    /// </summary>
    public BicepValue<int> MinimumElasticInstanceCount 
    {
        get { Initialize(); return _minimumElasticInstanceCount!; }
        set { Initialize(); _minimumElasticInstanceCount!.Assign(value); }
    }
    private BicepValue<int>? _minimumElasticInstanceCount;

    /// <summary>
    /// The minimum strength TLS cipher suite allowed for an application.
    /// </summary>
    public BicepValue<AppServiceTlsCipherSuite> MinTlsCipherSuite 
    {
        get { Initialize(); return _minTlsCipherSuite!; }
        set { Initialize(); _minTlsCipherSuite!.Assign(value); }
    }
    private BicepValue<AppServiceTlsCipherSuite>? _minTlsCipherSuite;

    /// <summary>
    /// MinTlsVersion: configures the minimum version of TLS required for SSL
    /// requests.
    /// </summary>
    public BicepValue<AppServiceSupportedTlsVersion> MinTlsVersion 
    {
        get { Initialize(); return _minTlsVersion!; }
        set { Initialize(); _minTlsVersion!.Assign(value); }
    }
    private BicepValue<AppServiceSupportedTlsVersion>? _minTlsVersion;

    /// <summary>
    /// .NET Framework version.
    /// </summary>
    public BicepValue<string> NetFrameworkVersion 
    {
        get { Initialize(); return _netFrameworkVersion!; }
        set { Initialize(); _netFrameworkVersion!.Assign(value); }
    }
    private BicepValue<string>? _netFrameworkVersion;

    /// <summary>
    /// Version of Node.js.
    /// </summary>
    public BicepValue<string> NodeVersion 
    {
        get { Initialize(); return _nodeVersion!; }
        set { Initialize(); _nodeVersion!.Assign(value); }
    }
    private BicepValue<string>? _nodeVersion;

    /// <summary>
    /// Number of workers.
    /// </summary>
    public BicepValue<int> NumberOfWorkers 
    {
        get { Initialize(); return _numberOfWorkers!; }
        set { Initialize(); _numberOfWorkers!.Assign(value); }
    }
    private BicepValue<int>? _numberOfWorkers;

    /// <summary>
    /// Version of PHP.
    /// </summary>
    public BicepValue<string> PhpVersion 
    {
        get { Initialize(); return _phpVersion!; }
        set { Initialize(); _phpVersion!.Assign(value); }
    }
    private BicepValue<string>? _phpVersion;

    /// <summary>
    /// Version of PowerShell.
    /// </summary>
    public BicepValue<string> PowerShellVersion 
    {
        get { Initialize(); return _powerShellVersion!; }
        set { Initialize(); _powerShellVersion!.Assign(value); }
    }
    private BicepValue<string>? _powerShellVersion;

    /// <summary>
    /// Number of preWarmed instances.             This setting only applies to
    /// the Consumption and Elastic Plans
    /// </summary>
    public BicepValue<int> PreWarmedInstanceCount 
    {
        get { Initialize(); return _preWarmedInstanceCount!; }
        set { Initialize(); _preWarmedInstanceCount!.Assign(value); }
    }
    private BicepValue<int>? _preWarmedInstanceCount;

    /// <summary>
    /// Property to allow or block all public traffic.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// Publishing user name.
    /// </summary>
    public BicepValue<string> PublishingUsername 
    {
        get { Initialize(); return _publishingUsername!; }
        set { Initialize(); _publishingUsername!.Assign(value); }
    }
    private BicepValue<string>? _publishingUsername;

    /// <summary>
    /// Push endpoint settings.
    /// </summary>
    public WebAppPushSettings Push 
    {
        get { Initialize(); return _push!; }
        set { Initialize(); AssignOrReplace(ref _push, value); }
    }
    private WebAppPushSettings? _push;

    /// <summary>
    /// Version of Python.
    /// </summary>
    public BicepValue<string> PythonVersion 
    {
        get { Initialize(); return _pythonVersion!; }
        set { Initialize(); _pythonVersion!.Assign(value); }
    }
    private BicepValue<string>? _pythonVersion;

    /// <summary>
    /// Remote debugging version.
    /// </summary>
    public BicepValue<string> RemoteDebuggingVersion 
    {
        get { Initialize(); return _remoteDebuggingVersion!; }
        set { Initialize(); _remoteDebuggingVersion!.Assign(value); }
    }
    private BicepValue<string>? _remoteDebuggingVersion;

    /// <summary>
    /// Request tracing expiration time.
    /// </summary>
    public BicepValue<DateTimeOffset> RequestTracingExpirationOn 
    {
        get { Initialize(); return _requestTracingExpirationOn!; }
        set { Initialize(); _requestTracingExpirationOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _requestTracingExpirationOn;

    /// <summary>
    /// IP security restrictions for scm.
    /// </summary>
    public BicepList<AppServiceIPSecurityRestriction> ScmIPSecurityRestrictions 
    {
        get { Initialize(); return _scmIPSecurityRestrictions!; }
        set { Initialize(); _scmIPSecurityRestrictions!.Assign(value); }
    }
    private BicepList<AppServiceIPSecurityRestriction>? _scmIPSecurityRestrictions;

    /// <summary>
    /// Default action for scm access restriction if no rules are matched.
    /// </summary>
    public BicepValue<SiteDefaultAction> ScmIPSecurityRestrictionsDefaultAction 
    {
        get { Initialize(); return _scmIPSecurityRestrictionsDefaultAction!; }
        set { Initialize(); _scmIPSecurityRestrictionsDefaultAction!.Assign(value); }
    }
    private BicepValue<SiteDefaultAction>? _scmIPSecurityRestrictionsDefaultAction;

    /// <summary>
    /// ScmMinTlsVersion: configures the minimum version of TLS required for
    /// SSL requests for SCM site.
    /// </summary>
    public BicepValue<AppServiceSupportedTlsVersion> ScmMinTlsVersion 
    {
        get { Initialize(); return _scmMinTlsVersion!; }
        set { Initialize(); _scmMinTlsVersion!.Assign(value); }
    }
    private BicepValue<AppServiceSupportedTlsVersion>? _scmMinTlsVersion;

    /// <summary>
    /// SCM type.
    /// </summary>
    public BicepValue<ScmType> ScmType 
    {
        get { Initialize(); return _scmType!; }
        set { Initialize(); _scmType!.Assign(value); }
    }
    private BicepValue<ScmType>? _scmType;

    /// <summary>
    /// Tracing options.
    /// </summary>
    public BicepValue<string> TracingOptions 
    {
        get { Initialize(); return _tracingOptions!; }
        set { Initialize(); _tracingOptions!.Assign(value); }
    }
    private BicepValue<string>? _tracingOptions;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> Use32BitWorkerProcess 
    {
        get { Initialize(); return _use32BitWorkerProcess!; }
        set { Initialize(); _use32BitWorkerProcess!.Assign(value); }
    }
    private BicepValue<bool>? _use32BitWorkerProcess;

    /// <summary>
    /// Flag to use Managed Identity Creds for ACR pull.
    /// </summary>
    public BicepValue<bool> UseManagedIdentityCreds 
    {
        get { Initialize(); return _useManagedIdentityCreds!; }
        set { Initialize(); _useManagedIdentityCreds!.Assign(value); }
    }
    private BicepValue<bool>? _useManagedIdentityCreds;

    /// <summary>
    /// Virtual applications.
    /// </summary>
    public BicepList<VirtualApplication> VirtualApplications 
    {
        get { Initialize(); return _virtualApplications!; }
        set { Initialize(); _virtualApplications!.Assign(value); }
    }
    private BicepList<VirtualApplication>? _virtualApplications;

    /// <summary>
    /// Virtual Network name.
    /// </summary>
    public BicepValue<string> VnetName 
    {
        get { Initialize(); return _vnetName!; }
        set { Initialize(); _vnetName!.Assign(value); }
    }
    private BicepValue<string>? _vnetName;

    /// <summary>
    /// The number of private ports assigned to this app. These will be
    /// assigned dynamically on runtime.
    /// </summary>
    public BicepValue<int> VnetPrivatePortsCount 
    {
        get { Initialize(); return _vnetPrivatePortsCount!; }
        set { Initialize(); _vnetPrivatePortsCount!.Assign(value); }
    }
    private BicepValue<int>? _vnetPrivatePortsCount;

    /// <summary>
    /// Sets the time zone a site uses for generating timestamps. Compatible
    /// with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app
    /// setting takes precedence over this config. For Linux, expects tz
    /// database values https://www.iana.org/time-zones (for a quick reference
    /// see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For
    /// Windows, expects one of the time zones listed under
    /// HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time
    /// Zones.
    /// </summary>
    public BicepValue<string> WebsiteTimeZone 
    {
        get { Initialize(); return _websiteTimeZone!; }
        set { Initialize(); _websiteTimeZone!.Assign(value); }
    }
    private BicepValue<string>? _websiteTimeZone;

    /// <summary>
    /// Xenon App Framework and version.
    /// </summary>
    public BicepValue<string> WindowsFxVersion 
    {
        get { Initialize(); return _windowsFxVersion!; }
        set { Initialize(); _windowsFxVersion!.Assign(value); }
    }
    private BicepValue<string>? _windowsFxVersion;

    /// <summary>
    /// Explicit Managed Service Identity Id.
    /// </summary>
    public BicepValue<int> XManagedServiceIdentityId 
    {
        get { Initialize(); return _xManagedServiceIdentityId!; }
        set { Initialize(); _xManagedServiceIdentityId!.Assign(value); }
    }
    private BicepValue<int>? _xManagedServiceIdentityId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Site MachineKey.
    /// </summary>
    public SiteMachineKey MachineKey 
    {
        get { Initialize(); return _machineKey!; }
    }
    private SiteMachineKey? _machineKey;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent WebSiteSlot.
    /// </summary>
    public WebSiteSlot? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSiteSlot>? _parent;

    /// <summary>
    /// Creates a new WebSiteSlotConfig.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebSiteSlotConfig resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebSiteSlotConfig.</param>
    public WebSiteSlotConfig(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/slots/config", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebSiteSlotConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _acrUserManagedIdentityId = DefineProperty<string>("AcrUserManagedIdentityId", ["properties", "acrUserManagedIdentityID"]);
        _allowIPSecurityRestrictionsForScmToUseMain = DefineProperty<bool>("AllowIPSecurityRestrictionsForScmToUseMain", ["properties", "scmIpSecurityRestrictionsUseMain"]);
        _apiDefinitionUri = DefineProperty<Uri>("ApiDefinitionUri", ["properties", "apiDefinition", "url"]);
        _apiManagementConfigId = DefineProperty<string>("ApiManagementConfigId", ["properties", "apiManagementConfig", "id"]);
        _appCommandLine = DefineProperty<string>("AppCommandLine", ["properties", "appCommandLine"]);
        _appSettings = DefineListProperty<AppServiceNameValuePair>("AppSettings", ["properties", "appSettings"]);
        _autoHealRules = DefineModelProperty<AutoHealRules>("AutoHealRules", ["properties", "autoHealRules"]);
        _autoSwapSlotName = DefineProperty<string>("AutoSwapSlotName", ["properties", "autoSwapSlotName"]);
        _azureStorageAccounts = DefineDictionaryProperty<AppServiceStorageAccessInfo>("AzureStorageAccounts", ["properties", "azureStorageAccounts"]);
        _connectionStrings = DefineListProperty<ConnStringInfo>("ConnectionStrings", ["properties", "connectionStrings"]);
        _cors = DefineModelProperty<AppServiceCorsSettings>("Cors", ["properties", "cors"]);
        _defaultDocuments = DefineListProperty<string>("DefaultDocuments", ["properties", "defaultDocuments"]);
        _documentRoot = DefineProperty<string>("DocumentRoot", ["properties", "documentRoot"]);
        _elasticWebAppScaleLimit = DefineProperty<int>("ElasticWebAppScaleLimit", ["properties", "elasticWebAppScaleLimit"]);
        _experimentsRampUpRules = DefineListProperty<RampUpRule>("ExperimentsRampUpRules", ["properties", "experiments", "rampUpRules"]);
        _ftpsState = DefineProperty<AppServiceFtpsState>("FtpsState", ["properties", "ftpsState"]);
        _functionAppScaleLimit = DefineProperty<int>("FunctionAppScaleLimit", ["properties", "functionAppScaleLimit"]);
        _handlerMappings = DefineListProperty<HttpRequestHandlerMapping>("HandlerMappings", ["properties", "handlerMappings"]);
        _healthCheckPath = DefineProperty<string>("HealthCheckPath", ["properties", "healthCheckPath"]);
        _iPSecurityRestrictions = DefineListProperty<AppServiceIPSecurityRestriction>("IPSecurityRestrictions", ["properties", "ipSecurityRestrictions"]);
        _iPSecurityRestrictionsDefaultAction = DefineProperty<SiteDefaultAction>("IPSecurityRestrictionsDefaultAction", ["properties", "ipSecurityRestrictionsDefaultAction"]);
        _isAlwaysOn = DefineProperty<bool>("IsAlwaysOn", ["properties", "alwaysOn"]);
        _isAutoHealEnabled = DefineProperty<bool>("IsAutoHealEnabled", ["properties", "autoHealEnabled"]);
        _isDetailedErrorLoggingEnabled = DefineProperty<bool>("IsDetailedErrorLoggingEnabled", ["properties", "detailedErrorLoggingEnabled"]);
        _isFunctionsRuntimeScaleMonitoringEnabled = DefineProperty<bool>("IsFunctionsRuntimeScaleMonitoringEnabled", ["properties", "functionsRuntimeScaleMonitoringEnabled"]);
        _isHttp20Enabled = DefineProperty<bool>("IsHttp20Enabled", ["properties", "http20Enabled"]);
        _isHttpLoggingEnabled = DefineProperty<bool>("IsHttpLoggingEnabled", ["properties", "httpLoggingEnabled"]);
        _isLocalMySqlEnabled = DefineProperty<bool>("IsLocalMySqlEnabled", ["properties", "localMySqlEnabled"]);
        _isRemoteDebuggingEnabled = DefineProperty<bool>("IsRemoteDebuggingEnabled", ["properties", "remoteDebuggingEnabled"]);
        _isRequestTracingEnabled = DefineProperty<bool>("IsRequestTracingEnabled", ["properties", "requestTracingEnabled"]);
        _isVnetRouteAllEnabled = DefineProperty<bool>("IsVnetRouteAllEnabled", ["properties", "vnetRouteAllEnabled"]);
        _isWebSocketsEnabled = DefineProperty<bool>("IsWebSocketsEnabled", ["properties", "webSocketsEnabled"]);
        _javaContainer = DefineProperty<string>("JavaContainer", ["properties", "javaContainer"]);
        _javaContainerVersion = DefineProperty<string>("JavaContainerVersion", ["properties", "javaContainerVersion"]);
        _javaVersion = DefineProperty<string>("JavaVersion", ["properties", "javaVersion"]);
        _keyVaultReferenceIdentity = DefineProperty<string>("KeyVaultReferenceIdentity", ["properties", "keyVaultReferenceIdentity"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _limits = DefineModelProperty<SiteLimits>("Limits", ["properties", "limits"]);
        _linuxFxVersion = DefineProperty<string>("LinuxFxVersion", ["properties", "linuxFxVersion"]);
        _loadBalancing = DefineProperty<SiteLoadBalancing>("LoadBalancing", ["properties", "loadBalancing"]);
        _logsDirectorySizeLimit = DefineProperty<int>("LogsDirectorySizeLimit", ["properties", "logsDirectorySizeLimit"]);
        _managedPipelineMode = DefineProperty<ManagedPipelineMode>("ManagedPipelineMode", ["properties", "managedPipelineMode"]);
        _managedServiceIdentityId = DefineProperty<int>("ManagedServiceIdentityId", ["properties", "managedServiceIdentityId"]);
        _metadata = DefineListProperty<AppServiceNameValuePair>("Metadata", ["properties", "metadata"]);
        _minimumElasticInstanceCount = DefineProperty<int>("MinimumElasticInstanceCount", ["properties", "minimumElasticInstanceCount"]);
        _minTlsCipherSuite = DefineProperty<AppServiceTlsCipherSuite>("MinTlsCipherSuite", ["properties", "minTlsCipherSuite"]);
        _minTlsVersion = DefineProperty<AppServiceSupportedTlsVersion>("MinTlsVersion", ["properties", "minTlsVersion"]);
        _netFrameworkVersion = DefineProperty<string>("NetFrameworkVersion", ["properties", "netFrameworkVersion"]);
        _nodeVersion = DefineProperty<string>("NodeVersion", ["properties", "nodeVersion"]);
        _numberOfWorkers = DefineProperty<int>("NumberOfWorkers", ["properties", "numberOfWorkers"]);
        _phpVersion = DefineProperty<string>("PhpVersion", ["properties", "phpVersion"]);
        _powerShellVersion = DefineProperty<string>("PowerShellVersion", ["properties", "powerShellVersion"]);
        _preWarmedInstanceCount = DefineProperty<int>("PreWarmedInstanceCount", ["properties", "preWarmedInstanceCount"]);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _publishingUsername = DefineProperty<string>("PublishingUsername", ["properties", "publishingUsername"]);
        _push = DefineModelProperty<WebAppPushSettings>("Push", ["properties", "push"]);
        _pythonVersion = DefineProperty<string>("PythonVersion", ["properties", "pythonVersion"]);
        _remoteDebuggingVersion = DefineProperty<string>("RemoteDebuggingVersion", ["properties", "remoteDebuggingVersion"]);
        _requestTracingExpirationOn = DefineProperty<DateTimeOffset>("RequestTracingExpirationOn", ["properties", "requestTracingExpirationTime"]);
        _scmIPSecurityRestrictions = DefineListProperty<AppServiceIPSecurityRestriction>("ScmIPSecurityRestrictions", ["properties", "scmIpSecurityRestrictions"]);
        _scmIPSecurityRestrictionsDefaultAction = DefineProperty<SiteDefaultAction>("ScmIPSecurityRestrictionsDefaultAction", ["properties", "scmIpSecurityRestrictionsDefaultAction"]);
        _scmMinTlsVersion = DefineProperty<AppServiceSupportedTlsVersion>("ScmMinTlsVersion", ["properties", "scmMinTlsVersion"]);
        _scmType = DefineProperty<ScmType>("ScmType", ["properties", "scmType"]);
        _tracingOptions = DefineProperty<string>("TracingOptions", ["properties", "tracingOptions"]);
        _use32BitWorkerProcess = DefineProperty<bool>("Use32BitWorkerProcess", ["properties", "use32BitWorkerProcess"]);
        _useManagedIdentityCreds = DefineProperty<bool>("UseManagedIdentityCreds", ["properties", "acrUseManagedIdentityCreds"]);
        _virtualApplications = DefineListProperty<VirtualApplication>("VirtualApplications", ["properties", "virtualApplications"]);
        _vnetName = DefineProperty<string>("VnetName", ["properties", "vnetName"]);
        _vnetPrivatePortsCount = DefineProperty<int>("VnetPrivatePortsCount", ["properties", "vnetPrivatePortsCount"]);
        _websiteTimeZone = DefineProperty<string>("WebsiteTimeZone", ["properties", "websiteTimeZone"]);
        _windowsFxVersion = DefineProperty<string>("WindowsFxVersion", ["properties", "windowsFxVersion"]);
        _xManagedServiceIdentityId = DefineProperty<int>("XManagedServiceIdentityId", ["properties", "xManagedServiceIdentityId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _machineKey = DefineModelProperty<SiteMachineKey>("MachineKey", ["properties", "machineKey"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<WebSiteSlot>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported WebSiteSlotConfig resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing WebSiteSlotConfig.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebSiteSlotConfig resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebSiteSlotConfig.</param>
    /// <returns>The existing WebSiteSlotConfig resource.</returns>
    public static WebSiteSlotConfig FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
