// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// StaticSiteBuildDatabaseConnection.
/// </summary>
public partial class StaticSiteBuildDatabaseConnection : ProvisionableResource
{
    /// <summary>
    /// Name of the database connection.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// If present, the identity is used in conjunction with connection string
    /// to connect to the database. Use of the system-assigned managed
    /// identity is indicated with the string &apos;SystemAssigned&apos;,
    /// while use of a user-assigned managed identity is indicated with the
    /// resource id of the managed identity resource.
    /// </summary>
    public BicepValue<string> ConnectionIdentity 
    {
        get { Initialize(); return _connectionIdentity!; }
        set { Initialize(); _connectionIdentity!.Assign(value); }
    }
    private BicepValue<string>? _connectionIdentity;

    /// <summary>
    /// The connection string to use to connect to the database.
    /// </summary>
    public BicepValue<string> ConnectionString 
    {
        get { Initialize(); return _connectionString!; }
        set { Initialize(); _connectionString!.Assign(value); }
    }
    private BicepValue<string>? _connectionString;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The region of the database resource.
    /// </summary>
    public BicepValue<string> Region 
    {
        get { Initialize(); return _region!; }
        set { Initialize(); _region!.Assign(value); }
    }
    private BicepValue<string>? _region;

    /// <summary>
    /// The resource id of the database.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// A list of configuration files associated with this database connection.
    /// </summary>
    public BicepList<StaticSiteDatabaseConnectionConfigurationFileOverview> ConfigurationFiles 
    {
        get { Initialize(); return _configurationFiles!; }
    }
    private BicepList<StaticSiteDatabaseConnectionConfigurationFileOverview>? _configurationFiles;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new StaticSiteBuildDatabaseConnection.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSiteBuildDatabaseConnection
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSiteBuildDatabaseConnection.</param>
    public StaticSiteBuildDatabaseConnection(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/staticSites/builds/databaseConnections", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StaticSiteBuildDatabaseConnection.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _connectionIdentity = DefineProperty<string>("ConnectionIdentity", ["properties", "connectionIdentity"]);
        _connectionString = DefineProperty<string>("ConnectionString", ["properties", "connectionString"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _region = DefineProperty<string>("Region", ["properties", "region"]);
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
        _configurationFiles = DefineListProperty<StaticSiteDatabaseConnectionConfigurationFileOverview>("ConfigurationFiles", ["properties", "configurationFiles"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported StaticSiteBuildDatabaseConnection resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";
    }

    /// <summary>
    /// Creates a reference to an existing StaticSiteBuildDatabaseConnection.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSiteBuildDatabaseConnection
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSiteBuildDatabaseConnection.</param>
    /// <returns>The existing StaticSiteBuildDatabaseConnection resource.</returns>
    public static StaticSiteBuildDatabaseConnection FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
