// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// StaticSiteBasicAuthProperty.
/// </summary>
public partial class StaticSiteBasicAuthProperty : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// State indicating if basic auth is enabled and for what environments it
    /// is active.
    /// </summary>
    public BicepValue<string> ApplicableEnvironmentsMode 
    {
        get { Initialize(); return _applicableEnvironmentsMode!; }
        set { Initialize(); _applicableEnvironmentsMode!.Assign(value); }
    }
    private BicepValue<string>? _applicableEnvironmentsMode;

    /// <summary>
    /// The list of enabled environments for Basic Auth if
    /// ApplicableEnvironmentsMode is set to SpecifiedEnvironments.
    /// </summary>
    public BicepList<string> Environments 
    {
        get { Initialize(); return _environments!; }
        set { Initialize(); _environments!.Assign(value); }
    }
    private BicepList<string>? _environments;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The password for basic auth.
    /// </summary>
    public BicepValue<string> Password 
    {
        get { Initialize(); return _password!; }
        set { Initialize(); _password!.Assign(value); }
    }
    private BicepValue<string>? _password;

    /// <summary>
    /// Url to the secret in Key Vault.
    /// </summary>
    public BicepValue<Uri> SecretUri 
    {
        get { Initialize(); return _secretUri!; }
        set { Initialize(); _secretUri!.Assign(value); }
    }
    private BicepValue<Uri>? _secretUri;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// State indicating if basic auth has a secret and what type it is.
    /// </summary>
    public BicepValue<string> SecretState 
    {
        get { Initialize(); return _secretState!; }
    }
    private BicepValue<string>? _secretState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent StaticSite.
    /// </summary>
    public StaticSite? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<StaticSite>? _parent;

    /// <summary>
    /// Creates a new StaticSiteBasicAuthProperty.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSiteBasicAuthProperty
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSiteBasicAuthProperty.</param>
    public StaticSiteBasicAuthProperty(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/staticSites/basicAuth", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StaticSiteBasicAuthProperty.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _applicableEnvironmentsMode = DefineProperty<string>("ApplicableEnvironmentsMode", ["properties", "applicableEnvironmentsMode"]);
        _environments = DefineListProperty<string>("Environments", ["properties", "environments"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _password = DefineProperty<string>("Password", ["properties", "password"]);
        _secretUri = DefineProperty<Uri>("SecretUri", ["properties", "secretUrl"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _secretState = DefineProperty<string>("SecretState", ["properties", "secretState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<StaticSite>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported StaticSiteBasicAuthProperty resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";
    }

    /// <summary>
    /// Creates a reference to an existing StaticSiteBasicAuthProperty.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSiteBasicAuthProperty
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSiteBasicAuthProperty.</param>
    /// <returns>The existing StaticSiteBasicAuthProperty resource.</returns>
    public static StaticSiteBasicAuthProperty FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
