// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppService;

/// <summary>
/// StaticSite.
/// </summary>
public partial class StaticSite : ProvisionableResource
{
    /// <summary>
    /// Name of the static site to create or update.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if config file is locked for this static
    /// web app; otherwise, &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> AllowConfigFileUpdates 
    {
        get { Initialize(); return _allowConfigFileUpdates!; }
        set { Initialize(); _allowConfigFileUpdates!.Assign(value); }
    }
    private BicepValue<bool>? _allowConfigFileUpdates;

    /// <summary>
    /// The target branch in the repository.
    /// </summary>
    public BicepValue<string> Branch 
    {
        get { Initialize(); return _branch!; }
        set { Initialize(); _branch!.Assign(value); }
    }
    private BicepValue<string>? _branch;

    /// <summary>
    /// Build properties to configure on the repository.
    /// </summary>
    public StaticSiteBuildProperties BuildProperties 
    {
        get { Initialize(); return _buildProperties!; }
        set { Initialize(); AssignOrReplace(ref _buildProperties, value); }
    }
    private StaticSiteBuildProperties? _buildProperties;

    /// <summary>
    /// State indicating the status of the enterprise grade CDN serving traffic
    /// to the static web app.
    /// </summary>
    public BicepValue<EnterpriseGradeCdnStatus> EnterpriseGradeCdnStatus 
    {
        get { Initialize(); return _enterpriseGradeCdnStatus!; }
        set { Initialize(); _enterpriseGradeCdnStatus!.Assign(value); }
    }
    private BicepValue<EnterpriseGradeCdnStatus>? _enterpriseGradeCdnStatus;

    /// <summary>
    /// Managed service identity.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The provider that submitted the last deployment to the primary
    /// environment of the static site.
    /// </summary>
    public BicepValue<string> Provider 
    {
        get { Initialize(); return _provider!; }
        set { Initialize(); _provider!.Assign(value); }
    }
    private BicepValue<string>? _provider;

    /// <summary>
    /// State indicating whether public traffic are allowed or not for a static
    /// web app. Allowed Values: &apos;Enabled&apos;, &apos;Disabled&apos; or
    /// an empty string.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// A user&apos;s github repository token. This is used to setup the Github
    /// Actions workflow file and API secrets.
    /// </summary>
    public BicepValue<string> RepositoryToken 
    {
        get { Initialize(); return _repositoryToken!; }
        set { Initialize(); _repositoryToken!.Assign(value); }
    }
    private BicepValue<string>? _repositoryToken;

    /// <summary>
    /// URL for the repository of the static site.
    /// </summary>
    public BicepValue<Uri> RepositoryUri 
    {
        get { Initialize(); return _repositoryUri!; }
        set { Initialize(); _repositoryUri!.Assign(value); }
    }
    private BicepValue<Uri>? _repositoryUri;

    /// <summary>
    /// Description of a SKU for a scalable resource.
    /// </summary>
    public AppServiceSkuDescription Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private AppServiceSkuDescription? _sku;

    /// <summary>
    /// State indicating whether staging environments are allowed or not
    /// allowed for a static web app.
    /// </summary>
    public BicepValue<StagingEnvironmentPolicy> StagingEnvironmentPolicy 
    {
        get { Initialize(); return _stagingEnvironmentPolicy!; }
        set { Initialize(); _stagingEnvironmentPolicy!.Assign(value); }
    }
    private BicepValue<StagingEnvironmentPolicy>? _stagingEnvironmentPolicy;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Template options for generating a new repository.
    /// </summary>
    public StaticSiteTemplate TemplateProperties 
    {
        get { Initialize(); return _templateProperties!; }
        set { Initialize(); AssignOrReplace(ref _templateProperties, value); }
    }
    private StaticSiteTemplate? _templateProperties;

    /// <summary>
    /// The content distribution endpoint for the static site.
    /// </summary>
    public BicepValue<string> ContentDistributionEndpoint 
    {
        get { Initialize(); return _contentDistributionEndpoint!; }
    }
    private BicepValue<string>? _contentDistributionEndpoint;

    /// <summary>
    /// The custom domains associated with this static site.
    /// </summary>
    public BicepList<string> CustomDomains 
    {
        get { Initialize(); return _customDomains!; }
    }
    private BicepList<string>? _customDomains;

    /// <summary>
    /// Database connections for the static site.
    /// </summary>
    public BicepList<StaticSiteDatabaseConnectionOverview> DatabaseConnections 
    {
        get { Initialize(); return _databaseConnections!; }
    }
    private BicepList<StaticSiteDatabaseConnectionOverview>? _databaseConnections;

    /// <summary>
    /// The default autogenerated hostname for the static site.
    /// </summary>
    public BicepValue<string> DefaultHostname 
    {
        get { Initialize(); return _defaultHostname!; }
    }
    private BicepValue<string>? _defaultHostname;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Identity to use for Key Vault Reference authentication.
    /// </summary>
    public BicepValue<string> KeyVaultReferenceIdentity 
    {
        get { Initialize(); return _keyVaultReferenceIdentity!; }
    }
    private BicepValue<string>? _keyVaultReferenceIdentity;

    /// <summary>
    /// Backends linked to the static side.
    /// </summary>
    public BicepList<StaticSiteLinkedBackendInfo> LinkedBackends 
    {
        get { Initialize(); return _linkedBackends!; }
    }
    private BicepList<StaticSiteLinkedBackendInfo>? _linkedBackends;

    /// <summary>
    /// Private endpoint connections.
    /// </summary>
    public BicepList<ResponseMessageEnvelopeRemotePrivateEndpointConnection> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<ResponseMessageEnvelopeRemotePrivateEndpointConnection>? _privateEndpointConnections;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// User provided function apps registered with the static site.
    /// </summary>
    public BicepList<StaticSiteUserProvidedFunctionAppData> UserProvidedFunctionApps 
    {
        get { Initialize(); return _userProvidedFunctionApps!; }
    }
    private BicepList<StaticSiteUserProvidedFunctionAppData>? _userProvidedFunctionApps;

    /// <summary>
    /// Creates a new StaticSite.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSite resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSite.</param>
    public StaticSite(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/staticSites", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StaticSite.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _allowConfigFileUpdates = DefineProperty<bool>("AllowConfigFileUpdates", ["properties", "allowConfigFileUpdates"]);
        _branch = DefineProperty<string>("Branch", ["properties", "branch"]);
        _buildProperties = DefineModelProperty<StaticSiteBuildProperties>("BuildProperties", ["properties", "buildProperties"]);
        _enterpriseGradeCdnStatus = DefineProperty<EnterpriseGradeCdnStatus>("EnterpriseGradeCdnStatus", ["properties", "enterpriseGradeCdnStatus"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _provider = DefineProperty<string>("Provider", ["properties", "provider"]);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _repositoryToken = DefineProperty<string>("RepositoryToken", ["properties", "repositoryToken"]);
        _repositoryUri = DefineProperty<Uri>("RepositoryUri", ["properties", "repositoryUrl"]);
        _sku = DefineModelProperty<AppServiceSkuDescription>("Sku", ["sku"]);
        _stagingEnvironmentPolicy = DefineProperty<StagingEnvironmentPolicy>("StagingEnvironmentPolicy", ["properties", "stagingEnvironmentPolicy"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _templateProperties = DefineModelProperty<StaticSiteTemplate>("TemplateProperties", ["properties", "templateProperties"]);
        _contentDistributionEndpoint = DefineProperty<string>("ContentDistributionEndpoint", ["properties", "contentDistributionEndpoint"], isOutput: true);
        _customDomains = DefineListProperty<string>("CustomDomains", ["properties", "customDomains"], isOutput: true);
        _databaseConnections = DefineListProperty<StaticSiteDatabaseConnectionOverview>("DatabaseConnections", ["properties", "databaseConnections"], isOutput: true);
        _defaultHostname = DefineProperty<string>("DefaultHostname", ["properties", "defaultHostname"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _keyVaultReferenceIdentity = DefineProperty<string>("KeyVaultReferenceIdentity", ["properties", "keyVaultReferenceIdentity"], isOutput: true);
        _linkedBackends = DefineListProperty<StaticSiteLinkedBackendInfo>("LinkedBackends", ["properties", "linkedBackends"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<ResponseMessageEnvelopeRemotePrivateEndpointConnection>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _userProvidedFunctionApps = DefineListProperty<StaticSiteUserProvidedFunctionAppData>("UserProvidedFunctionApps", ["properties", "userProvidedFunctionApps"], isOutput: true);
    }

    /// <summary>
    /// Supported StaticSite resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";
    }

    /// <summary>
    /// Creates a reference to an existing StaticSite.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StaticSite resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StaticSite.</param>
    /// <returns>The existing StaticSite resource.</returns>
    public static StaticSite FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
