// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SiteVirtualNetworkConnection.
/// </summary>
public partial class SiteVirtualNetworkConnection : ProvisionableResource
{
    /// <summary>
    /// Name of an existing Virtual Network.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// A certificate file (.cer) blob containing the public key of the private
    /// key used to authenticate a             Point-To-Site VPN connection.
    /// </summary>
    public BicepValue<string> CertBlob 
    {
        get { Initialize(); return _certBlob!; }
        set { Initialize(); _certBlob!.Assign(value); }
    }
    private BicepValue<string>? _certBlob;

    /// <summary>
    /// DNS servers to be used by this Virtual Network. This should be a
    /// comma-separated list of IP addresses.
    /// </summary>
    public BicepValue<string> DnsServers 
    {
        get { Initialize(); return _dnsServers!; }
        set { Initialize(); _dnsServers!.Assign(value); }
    }
    private BicepValue<string>? _dnsServers;

    /// <summary>
    /// Flag that is used to denote if this is VNET injection.
    /// </summary>
    public BicepValue<bool> IsSwift 
    {
        get { Initialize(); return _isSwift!; }
        set { Initialize(); _isSwift!.Assign(value); }
    }
    private BicepValue<bool>? _isSwift;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The Virtual Network&apos;s resource ID.
    /// </summary>
    public BicepValue<ResourceIdentifier> VnetResourceId 
    {
        get { Initialize(); return _vnetResourceId!; }
        set { Initialize(); _vnetResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _vnetResourceId;

    /// <summary>
    /// The client certificate thumbprint.
    /// </summary>
    public BicepValue<string> CertThumbprintString 
    {
        get { Initialize(); return _certThumbprintString!; }
    }
    private BicepValue<string>? _certThumbprintString;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if a resync is required; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsResyncRequired 
    {
        get { Initialize(); return _isResyncRequired!; }
    }
    private BicepValue<bool>? _isResyncRequired;

    /// <summary>
    /// The routes that this Virtual Network connection uses.
    /// </summary>
    public BicepList<AppServiceVirtualNetworkRoute> Routes 
    {
        get { Initialize(); return _routes!; }
    }
    private BicepList<AppServiceVirtualNetworkRoute>? _routes;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent WebSite.
    /// </summary>
    public WebSite? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSite>? _parent;

    /// <summary>
    /// Creates a new SiteVirtualNetworkConnection.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteVirtualNetworkConnection
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteVirtualNetworkConnection.</param>
    public SiteVirtualNetworkConnection(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/virtualNetworkConnections", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteVirtualNetworkConnection.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _certBlob = DefineProperty<string>("CertBlob", ["properties", "certBlob"]);
        _dnsServers = DefineProperty<string>("DnsServers", ["properties", "dnsServers"]);
        _isSwift = DefineProperty<bool>("IsSwift", ["properties", "isSwift"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _vnetResourceId = DefineProperty<ResourceIdentifier>("VnetResourceId", ["properties", "vnetResourceId"]);
        _certThumbprintString = DefineProperty<string>("CertThumbprintString", ["properties", "certThumbprint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isResyncRequired = DefineProperty<bool>("IsResyncRequired", ["properties", "resyncRequired"], isOutput: true);
        _routes = DefineListProperty<AppServiceVirtualNetworkRoute>("Routes", ["properties", "routes"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<WebSite>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SiteVirtualNetworkConnection resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing SiteVirtualNetworkConnection.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteVirtualNetworkConnection
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteVirtualNetworkConnection.</param>
    /// <returns>The existing SiteVirtualNetworkConnection resource.</returns>
    public static SiteVirtualNetworkConnection FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
