// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SiteSlotHostNameBinding.
/// </summary>
public partial class SiteSlotHostNameBinding : ProvisionableResource
{
    /// <summary>
    /// Hostname in the hostname binding.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Azure resource name.
    /// </summary>
    public BicepValue<string> AzureResourceName 
    {
        get { Initialize(); return _azureResourceName!; }
        set { Initialize(); _azureResourceName!.Assign(value); }
    }
    private BicepValue<string>? _azureResourceName;

    /// <summary>
    /// Azure resource type.
    /// </summary>
    public BicepValue<AppServiceResourceType> AzureResourceType 
    {
        get { Initialize(); return _azureResourceType!; }
        set { Initialize(); _azureResourceType!.Assign(value); }
    }
    private BicepValue<AppServiceResourceType>? _azureResourceType;

    /// <summary>
    /// Custom DNS record type.
    /// </summary>
    public BicepValue<CustomHostNameDnsRecordType> CustomHostNameDnsRecordType 
    {
        get { Initialize(); return _customHostNameDnsRecordType!; }
        set { Initialize(); _customHostNameDnsRecordType!.Assign(value); }
    }
    private BicepValue<CustomHostNameDnsRecordType>? _customHostNameDnsRecordType;

    /// <summary>
    /// Fully qualified ARM domain resource URI.
    /// </summary>
    public BicepValue<string> DomainId 
    {
        get { Initialize(); return _domainId!; }
        set { Initialize(); _domainId!.Assign(value); }
    }
    private BicepValue<string>? _domainId;

    /// <summary>
    /// Hostname type.
    /// </summary>
    public BicepValue<AppServiceHostNameType> HostNameType 
    {
        get { Initialize(); return _hostNameType!; }
        set { Initialize(); _hostNameType!.Assign(value); }
    }
    private BicepValue<AppServiceHostNameType>? _hostNameType;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// App Service app name.
    /// </summary>
    public BicepValue<string> SiteName 
    {
        get { Initialize(); return _siteName!; }
        set { Initialize(); _siteName!.Assign(value); }
    }
    private BicepValue<string>? _siteName;

    /// <summary>
    /// SSL type.
    /// </summary>
    public BicepValue<HostNameBindingSslState> SslState 
    {
        get { Initialize(); return _sslState!; }
        set { Initialize(); _sslState!.Assign(value); }
    }
    private BicepValue<HostNameBindingSslState>? _sslState;

    /// <summary>
    /// SSL certificate thumbprint.
    /// </summary>
    public BicepValue<string> ThumbprintString 
    {
        get { Initialize(); return _thumbprintString!; }
        set { Initialize(); _thumbprintString!.Assign(value); }
    }
    private BicepValue<string>? _thumbprintString;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Virtual IP address assigned to the hostname if IP based SSL is enabled.
    /// </summary>
    public BicepValue<string> VirtualIP 
    {
        get { Initialize(); return _virtualIP!; }
    }
    private BicepValue<string>? _virtualIP;

    /// <summary>
    /// Gets or sets a reference to the parent WebSiteSlot.
    /// </summary>
    public WebSiteSlot? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSiteSlot>? _parent;

    /// <summary>
    /// Creates a new SiteSlotHostNameBinding.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteSlotHostNameBinding resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteSlotHostNameBinding.</param>
    public SiteSlotHostNameBinding(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/slots/hostNameBindings", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteSlotHostNameBinding.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _azureResourceName = DefineProperty<string>("AzureResourceName", ["properties", "azureResourceName"]);
        _azureResourceType = DefineProperty<AppServiceResourceType>("AzureResourceType", ["properties", "azureResourceType"]);
        _customHostNameDnsRecordType = DefineProperty<CustomHostNameDnsRecordType>("CustomHostNameDnsRecordType", ["properties", "customHostNameDnsRecordType"]);
        _domainId = DefineProperty<string>("DomainId", ["properties", "domainId"]);
        _hostNameType = DefineProperty<AppServiceHostNameType>("HostNameType", ["properties", "hostNameType"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _siteName = DefineProperty<string>("SiteName", ["properties", "siteName"]);
        _sslState = DefineProperty<HostNameBindingSslState>("SslState", ["properties", "sslState"]);
        _thumbprintString = DefineProperty<string>("ThumbprintString", ["properties", "thumbprint"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _virtualIP = DefineProperty<string>("VirtualIP", ["properties", "virtualIP"], isOutput: true);
        _parent = DefineResource<WebSiteSlot>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SiteSlotHostNameBinding resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";
    }

    /// <summary>
    /// Creates a reference to an existing SiteSlotHostNameBinding.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteSlotHostNameBinding resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteSlotHostNameBinding.</param>
    /// <returns>The existing SiteSlotHostNameBinding resource.</returns>
    public static SiteSlotHostNameBinding FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
