// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SiteHybridConnectionNamespaceRelay.
/// </summary>
public partial class SiteHybridConnectionNamespaceRelay : ProvisionableResource
{
    /// <summary>
    /// The namespace for this hybrid connection.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The relay name for this hybrid connection.
    /// </summary>
    public BicepValue<string> RelayName 
    {
        get { Initialize(); return _relayName!; }
        set { Initialize(); _relayName!.Assign(value); }
    }
    private BicepValue<string>? _relayName;

    /// <summary>
    /// The hostname of the endpoint.
    /// </summary>
    public BicepValue<string> Hostname 
    {
        get { Initialize(); return _hostname!; }
        set { Initialize(); _hostname!.Assign(value); }
    }
    private BicepValue<string>? _hostname;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The port of the endpoint.
    /// </summary>
    public BicepValue<int> Port 
    {
        get { Initialize(); return _port!; }
        set { Initialize(); _port!.Assign(value); }
    }
    private BicepValue<int>? _port;

    /// <summary>
    /// The ARM URI to the Service Bus relay.
    /// </summary>
    public BicepValue<ResourceIdentifier> RelayArmId 
    {
        get { Initialize(); return _relayArmId!; }
        set { Initialize(); _relayArmId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _relayArmId;

    /// <summary>
    /// The name of the Service Bus key which has Send permissions. This is
    /// used to authenticate to Service Bus.
    /// </summary>
    public BicepValue<string> SendKeyName 
    {
        get { Initialize(); return _sendKeyName!; }
        set { Initialize(); _sendKeyName!.Assign(value); }
    }
    private BicepValue<string>? _sendKeyName;

    /// <summary>
    /// The value of the Service Bus key. This is used to authenticate to
    /// Service Bus. In ARM this key will not be returned
    /// normally, use the POST /listKeys API instead.
    /// </summary>
    public BicepValue<string> SendKeyValue 
    {
        get { Initialize(); return _sendKeyValue!; }
        set { Initialize(); _sendKeyValue!.Assign(value); }
    }
    private BicepValue<string>? _sendKeyValue;

    /// <summary>
    /// The name of the Service Bus namespace.
    /// </summary>
    public BicepValue<string> ServiceBusNamespace 
    {
        get { Initialize(); return _serviceBusNamespace!; }
        set { Initialize(); _serviceBusNamespace!.Assign(value); }
    }
    private BicepValue<string>? _serviceBusNamespace;

    /// <summary>
    /// The suffix for the service bus endpoint. By default this is
    /// .servicebus.windows.net.
    /// </summary>
    public BicepValue<string> ServiceBusSuffix 
    {
        get { Initialize(); return _serviceBusSuffix!; }
        set { Initialize(); _serviceBusSuffix!.Assign(value); }
    }
    private BicepValue<string>? _serviceBusSuffix;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new SiteHybridConnectionNamespaceRelay.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteHybridConnectionNamespaceRelay
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteHybridConnectionNamespaceRelay.</param>
    public SiteHybridConnectionNamespaceRelay(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/hybridConnectionNamespaces/relays", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SiteHybridConnectionNamespaceRelay.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _relayName = DefineProperty<string>("RelayName", ["properties", "relayName"], isRequired: true);
        _hostname = DefineProperty<string>("Hostname", ["properties", "hostname"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _port = DefineProperty<int>("Port", ["properties", "port"]);
        _relayArmId = DefineProperty<ResourceIdentifier>("RelayArmId", ["properties", "relayArmUri"]);
        _sendKeyName = DefineProperty<string>("SendKeyName", ["properties", "sendKeyName"]);
        _sendKeyValue = DefineProperty<string>("SendKeyValue", ["properties", "sendKeyValue"]);
        _serviceBusNamespace = DefineProperty<string>("ServiceBusNamespace", ["properties", "serviceBusNamespace"]);
        _serviceBusSuffix = DefineProperty<string>("ServiceBusSuffix", ["properties", "serviceBusSuffix"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing SiteHybridConnectionNamespaceRelay.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteHybridConnectionNamespaceRelay
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteHybridConnectionNamespaceRelay.</param>
    /// <returns>The existing SiteHybridConnectionNamespaceRelay resource.</returns>
    public static SiteHybridConnectionNamespaceRelay FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
