// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SiteDeployment.
/// </summary>
public partial class SiteDeployment : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Who authored the deployment.
    /// </summary>
    public BicepValue<string> Author 
    {
        get { Initialize(); return _author!; }
        set { Initialize(); _author!.Assign(value); }
    }
    private BicepValue<string>? _author;

    /// <summary>
    /// Author email.
    /// </summary>
    public BicepValue<string> AuthorEmail 
    {
        get { Initialize(); return _authorEmail!; }
        set { Initialize(); _authorEmail!.Assign(value); }
    }
    private BicepValue<string>? _authorEmail;

    /// <summary>
    /// Who performed the deployment.
    /// </summary>
    public BicepValue<string> Deployer 
    {
        get { Initialize(); return _deployer!; }
        set { Initialize(); _deployer!.Assign(value); }
    }
    private BicepValue<string>? _deployer;

    /// <summary>
    /// Details on deployment.
    /// </summary>
    public BicepValue<string> Details 
    {
        get { Initialize(); return _details!; }
        set { Initialize(); _details!.Assign(value); }
    }
    private BicepValue<string>? _details;

    /// <summary>
    /// End time.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
        set { Initialize(); _endOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// True if deployment is currently active, false if completed and null if
    /// not started.
    /// </summary>
    public BicepValue<bool> IsActive 
    {
        get { Initialize(); return _isActive!; }
        set { Initialize(); _isActive!.Assign(value); }
    }
    private BicepValue<bool>? _isActive;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Details about deployment status.
    /// </summary>
    public BicepValue<string> Message 
    {
        get { Initialize(); return _message!; }
        set { Initialize(); _message!.Assign(value); }
    }
    private BicepValue<string>? _message;

    /// <summary>
    /// Start time.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Deployment status.
    /// </summary>
    public BicepValue<int> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<int>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent WebSite.
    /// </summary>
    public WebSite? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSite>? _parent;

    /// <summary>
    /// Creates a new SiteDeployment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteDeployment resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteDeployment.</param>
    public SiteDeployment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/deployments", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteDeployment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _author = DefineProperty<string>("Author", ["properties", "author"]);
        _authorEmail = DefineProperty<string>("AuthorEmail", ["properties", "author_email"]);
        _deployer = DefineProperty<string>("Deployer", ["properties", "deployer"]);
        _details = DefineProperty<string>("Details", ["properties", "details"]);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["properties", "end_time"]);
        _isActive = DefineProperty<bool>("IsActive", ["properties", "active"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _message = DefineProperty<string>("Message", ["properties", "message"]);
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["properties", "start_time"]);
        _status = DefineProperty<int>("Status", ["properties", "status"]);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<WebSite>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SiteDeployment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing SiteDeployment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteDeployment resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteDeployment.</param>
    /// <returns>The existing SiteDeployment resource.</returns>
    public static SiteDeployment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
