// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SiteContainer.
/// </summary>
public partial class SiteContainer : ProvisionableResource
{
    /// <summary>
    /// Site Container Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Auth Type.
    /// </summary>
    public BicepValue<SiteContainerAuthType> AuthType 
    {
        get { Initialize(); return _authType!; }
        set { Initialize(); _authType!.Assign(value); }
    }
    private BicepValue<SiteContainerAuthType>? _authType;

    /// <summary>
    /// List of environment variables.
    /// </summary>
    public BicepList<WebAppEnvironmentVariable> EnvironmentVariables 
    {
        get { Initialize(); return _environmentVariables!; }
        set { Initialize(); _environmentVariables!.Assign(value); }
    }
    private BicepList<WebAppEnvironmentVariable>? _environmentVariables;

    /// <summary>
    /// Image Name.
    /// </summary>
    public BicepValue<string> Image 
    {
        get { Initialize(); return _image!; }
        set { Initialize(); _image!.Assign(value); }
    }
    private BicepValue<string>? _image;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the container is the main site
    /// container; &lt;code&gt;false&lt;/code&gt; otherwise.
    /// </summary>
    public BicepValue<bool> IsMain 
    {
        get { Initialize(); return _isMain!; }
        set { Initialize(); _isMain!.Assign(value); }
    }
    private BicepValue<bool>? _isMain;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Password Secret.
    /// </summary>
    public BicepValue<string> PasswordSecret 
    {
        get { Initialize(); return _passwordSecret!; }
        set { Initialize(); _passwordSecret!.Assign(value); }
    }
    private BicepValue<string>? _passwordSecret;

    /// <summary>
    /// StartUp Command.
    /// </summary>
    public BicepValue<string> StartUpCommand 
    {
        get { Initialize(); return _startUpCommand!; }
        set { Initialize(); _startUpCommand!.Assign(value); }
    }
    private BicepValue<string>? _startUpCommand;

    /// <summary>
    /// Target Port.
    /// </summary>
    public BicepValue<string> TargetPort 
    {
        get { Initialize(); return _targetPort!; }
        set { Initialize(); _targetPort!.Assign(value); }
    }
    private BicepValue<string>? _targetPort;

    /// <summary>
    /// UserManagedIdentity ClientId.
    /// </summary>
    public BicepValue<string> UserManagedIdentityClientId 
    {
        get { Initialize(); return _userManagedIdentityClientId!; }
        set { Initialize(); _userManagedIdentityClientId!.Assign(value); }
    }
    private BicepValue<string>? _userManagedIdentityClientId;

    /// <summary>
    /// User Name.
    /// </summary>
    public BicepValue<string> UserName 
    {
        get { Initialize(); return _userName!; }
        set { Initialize(); _userName!.Assign(value); }
    }
    private BicepValue<string>? _userName;

    /// <summary>
    /// List of volume mounts.
    /// </summary>
    public BicepList<SiteContainerVolumeMount> VolumeMounts 
    {
        get { Initialize(); return _volumeMounts!; }
        set { Initialize(); _volumeMounts!.Assign(value); }
    }
    private BicepList<SiteContainerVolumeMount>? _volumeMounts;

    /// <summary>
    /// Created Time.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Last Modified Time.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent WebSite.
    /// </summary>
    public WebSite? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<WebSite>? _parent;

    /// <summary>
    /// Creates a new SiteContainer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteContainer resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteContainer.</param>
    public SiteContainer(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/sites/sitecontainers", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteContainer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _authType = DefineProperty<SiteContainerAuthType>("AuthType", ["properties", "authType"]);
        _environmentVariables = DefineListProperty<WebAppEnvironmentVariable>("EnvironmentVariables", ["properties", "environmentVariables"]);
        _image = DefineProperty<string>("Image", ["properties", "image"]);
        _isMain = DefineProperty<bool>("IsMain", ["properties", "isMain"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _passwordSecret = DefineProperty<string>("PasswordSecret", ["properties", "passwordSecret"]);
        _startUpCommand = DefineProperty<string>("StartUpCommand", ["properties", "startUpCommand"]);
        _targetPort = DefineProperty<string>("TargetPort", ["properties", "targetPort"]);
        _userManagedIdentityClientId = DefineProperty<string>("UserManagedIdentityClientId", ["properties", "userManagedIdentityClientId"]);
        _userName = DefineProperty<string>("UserName", ["properties", "userName"]);
        _volumeMounts = DefineListProperty<SiteContainerVolumeMount>("VolumeMounts", ["properties", "volumeMounts"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "createdTime"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModifiedTime"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<WebSite>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported SiteContainer resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-08-01.
        /// </summary>
        public static readonly string V2016_08_01 = "2016-08-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-11-01.
        /// </summary>
        public static readonly string V2015_11_01 = "2015-11-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2015-01-01.
        /// </summary>
        public static readonly string V2015_01_01 = "2015-01-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing SiteContainer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the SiteContainer resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the SiteContainer.</param>
    /// <returns>The existing SiteContainer resource.</returns>
    public static SiteContainer FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
