// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// PublishingUser.
/// </summary>
public partial class PublishingUser : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Password used for publishing.
    /// </summary>
    public BicepValue<string> PublishingPassword 
    {
        get { Initialize(); return _publishingPassword!; }
        set { Initialize(); _publishingPassword!.Assign(value); }
    }
    private BicepValue<string>? _publishingPassword;

    /// <summary>
    /// Password hash used for publishing.
    /// </summary>
    public BicepValue<string> PublishingPasswordHash 
    {
        get { Initialize(); return _publishingPasswordHash!; }
        set { Initialize(); _publishingPasswordHash!.Assign(value); }
    }
    private BicepValue<string>? _publishingPasswordHash;

    /// <summary>
    /// Password hash salt used for publishing.
    /// </summary>
    public BicepValue<string> PublishingPasswordHashSalt 
    {
        get { Initialize(); return _publishingPasswordHashSalt!; }
        set { Initialize(); _publishingPasswordHashSalt!.Assign(value); }
    }
    private BicepValue<string>? _publishingPasswordHashSalt;

    /// <summary>
    /// Username used for publishing.
    /// </summary>
    public BicepValue<string> PublishingUserName 
    {
        get { Initialize(); return _publishingUserName!; }
        set { Initialize(); _publishingUserName!.Assign(value); }
    }
    private BicepValue<string>? _publishingUserName;

    /// <summary>
    /// Url of SCM site.
    /// </summary>
    public BicepValue<Uri> ScmUri 
    {
        get { Initialize(); return _scmUri!; }
        set { Initialize(); _scmUri!.Assign(value); }
    }
    private BicepValue<Uri>? _scmUri;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new PublishingUser.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PublishingUser resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PublishingUser.</param>
    public PublishingUser(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/publishingUsers", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PublishingUser.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _publishingPassword = DefineProperty<string>("PublishingPassword", ["properties", "publishingPassword"]);
        _publishingPasswordHash = DefineProperty<string>("PublishingPasswordHash", ["properties", "publishingPasswordHash"]);
        _publishingPasswordHashSalt = DefineProperty<string>("PublishingPasswordHashSalt", ["properties", "publishingPasswordHashSalt"]);
        _publishingUserName = DefineProperty<string>("PublishingUserName", ["properties", "publishingUserName"]);
        _scmUri = DefineProperty<Uri>("ScmUri", ["properties", "scmUri"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported PublishingUser resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing PublishingUser.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PublishingUser resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PublishingUser.</param>
    /// <returns>The existing PublishingUser resource.</returns>
    public static PublishingUser FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
