// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Push settings for the App.
/// </summary>
public partial class WebAppPushSettings : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets a flag indicating whether the Push endpoint is enabled.
    /// </summary>
    public BicepValue<bool> IsPushEnabled 
    {
        get { Initialize(); return _isPushEnabled!; }
        set { Initialize(); _isPushEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isPushEnabled;

    /// <summary>
    /// Gets or sets a JSON string containing a list of tags that are
    /// whitelisted for use by the push registration endpoint.
    /// </summary>
    public BicepValue<string> TagWhitelistJson 
    {
        get { Initialize(); return _tagWhitelistJson!; }
        set { Initialize(); _tagWhitelistJson!.Assign(value); }
    }
    private BicepValue<string>? _tagWhitelistJson;

    /// <summary>
    /// Gets or sets a JSON string containing a list of tags that require user
    /// authentication to be used in the push registration endpoint.
    /// Tags can consist of alphanumeric characters and the
    /// following:             &apos;_&apos;, &apos;@&apos;, &apos;#&apos;,
    /// &apos;.&apos;, &apos;:&apos;, &apos;-&apos;.             Validation
    /// should be performed at the PushRequestHandler.
    /// </summary>
    public BicepValue<string> TagsRequiringAuth 
    {
        get { Initialize(); return _tagsRequiringAuth!; }
        set { Initialize(); _tagsRequiringAuth!.Assign(value); }
    }
    private BicepValue<string>? _tagsRequiringAuth;

    /// <summary>
    /// Gets or sets a JSON string containing a list of dynamic tags that will
    /// be evaluated from user claims in the push registration endpoint.
    /// </summary>
    public BicepValue<string> DynamicTagsJson 
    {
        get { Initialize(); return _dynamicTagsJson!; }
        set { Initialize(); _dynamicTagsJson!.Assign(value); }
    }
    private BicepValue<string>? _dynamicTagsJson;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new WebAppPushSettings.
    /// </summary>
    public WebAppPushSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebAppPushSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isPushEnabled = DefineProperty<bool>("IsPushEnabled", ["properties", "isPushEnabled"]);
        _tagWhitelistJson = DefineProperty<string>("TagWhitelistJson", ["properties", "tagWhitelistJson"]);
        _tagsRequiringAuth = DefineProperty<string>("TagsRequiringAuth", ["properties", "tagsRequiringAuth"]);
        _dynamicTagsJson = DefineProperty<string>("DynamicTagsJson", ["properties", "dynamicTagsJson"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
