// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Directory for virtual application.
/// </summary>
public partial class VirtualDirectory : ProvisionableConstruct
{
    /// <summary>
    /// Path to virtual application.
    /// </summary>
    public BicepValue<string> VirtualPath 
    {
        get { Initialize(); return _virtualPath!; }
        set { Initialize(); _virtualPath!.Assign(value); }
    }
    private BicepValue<string>? _virtualPath;

    /// <summary>
    /// Physical path.
    /// </summary>
    public BicepValue<string> PhysicalPath 
    {
        get { Initialize(); return _physicalPath!; }
        set { Initialize(); _physicalPath!.Assign(value); }
    }
    private BicepValue<string>? _physicalPath;

    /// <summary>
    /// Creates a new VirtualDirectory.
    /// </summary>
    public VirtualDirectory()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of VirtualDirectory.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _virtualPath = DefineProperty<string>("VirtualPath", ["virtualPath"]);
        _physicalPath = DefineProperty<string>("PhysicalPath", ["physicalPath"]);
    }
}
