// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Trigger based on range of status codes.
/// </summary>
public partial class StatusCodesRangeBasedTrigger : ProvisionableConstruct
{
    /// <summary>
    /// HTTP status code.
    /// </summary>
    public BicepValue<string> StatusCodes 
    {
        get { Initialize(); return _statusCodes!; }
        set { Initialize(); _statusCodes!.Assign(value); }
    }
    private BicepValue<string>? _statusCodes;

    /// <summary>
    /// Gets or sets the path.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Request Count.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// Time interval.
    /// </summary>
    public BicepValue<string> TimeInterval 
    {
        get { Initialize(); return _timeInterval!; }
        set { Initialize(); _timeInterval!.Assign(value); }
    }
    private BicepValue<string>? _timeInterval;

    /// <summary>
    /// Creates a new StatusCodesRangeBasedTrigger.
    /// </summary>
    public StatusCodesRangeBasedTrigger()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StatusCodesRangeBasedTrigger.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _statusCodes = DefineProperty<string>("StatusCodes", ["statusCodes"]);
        _path = DefineProperty<string>("Path", ["path"]);
        _count = DefineProperty<int>("Count", ["count"]);
        _timeInterval = DefineProperty<string>("TimeInterval", ["timeInterval"]);
    }
}
