// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Trigger based on status code.
/// </summary>
public partial class StatusCodesBasedTrigger : ProvisionableConstruct
{
    /// <summary>
    /// HTTP status code.
    /// </summary>
    public BicepValue<int> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<int>? _status;

    /// <summary>
    /// Request Sub Status.
    /// </summary>
    public BicepValue<int> SubStatus 
    {
        get { Initialize(); return _subStatus!; }
        set { Initialize(); _subStatus!.Assign(value); }
    }
    private BicepValue<int>? _subStatus;

    /// <summary>
    /// Win32 error code.
    /// </summary>
    public BicepValue<int> Win32Status 
    {
        get { Initialize(); return _win32Status!; }
        set { Initialize(); _win32Status!.Assign(value); }
    }
    private BicepValue<int>? _win32Status;

    /// <summary>
    /// Request Count.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// Time interval.
    /// </summary>
    public BicepValue<string> TimeInterval 
    {
        get { Initialize(); return _timeInterval!; }
        set { Initialize(); _timeInterval!.Assign(value); }
    }
    private BicepValue<string>? _timeInterval;

    /// <summary>
    /// Request Path.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Creates a new StatusCodesBasedTrigger.
    /// </summary>
    public StatusCodesBasedTrigger()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StatusCodesBasedTrigger.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<int>("Status", ["status"]);
        _subStatus = DefineProperty<int>("SubStatus", ["subStatus"]);
        _win32Status = DefineProperty<int>("Win32Status", ["win32Status"]);
        _count = DefineProperty<int>("Count", ["count"]);
        _timeInterval = DefineProperty<string>("TimeInterval", ["timeInterval"]);
        _path = DefineProperty<string>("Path", ["path"]);
    }
}
