// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Template Options for the static site.
/// </summary>
public partial class StaticSiteTemplate : ProvisionableConstruct
{
    /// <summary>
    /// URL of the template repository. The newly generated repository will be
    /// based on this one.
    /// </summary>
    public BicepValue<Uri> TemplateRepositoryUri 
    {
        get { Initialize(); return _templateRepositoryUri!; }
        set { Initialize(); _templateRepositoryUri!.Assign(value); }
    }
    private BicepValue<Uri>? _templateRepositoryUri;

    /// <summary>
    /// Owner of the newly generated repository.
    /// </summary>
    public BicepValue<string> Owner 
    {
        get { Initialize(); return _owner!; }
        set { Initialize(); _owner!.Assign(value); }
    }
    private BicepValue<string>? _owner;

    /// <summary>
    /// Name of the newly generated repository.
    /// </summary>
    public BicepValue<string> RepositoryName 
    {
        get { Initialize(); return _repositoryName!; }
        set { Initialize(); _repositoryName!.Assign(value); }
    }
    private BicepValue<string>? _repositoryName;

    /// <summary>
    /// Description of the newly generated repository.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Whether or not the newly generated repository is a private repository.
    /// Defaults to false (i.e. public).
    /// </summary>
    public BicepValue<bool> IsPrivate 
    {
        get { Initialize(); return _isPrivate!; }
        set { Initialize(); _isPrivate!.Assign(value); }
    }
    private BicepValue<bool>? _isPrivate;

    /// <summary>
    /// Creates a new StaticSiteTemplate.
    /// </summary>
    public StaticSiteTemplate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StaticSiteTemplate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _templateRepositoryUri = DefineProperty<Uri>("TemplateRepositoryUri", ["templateRepositoryUrl"]);
        _owner = DefineProperty<string>("Owner", ["owner"]);
        _repositoryName = DefineProperty<string>("RepositoryName", ["repositoryName"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _isPrivate = DefineProperty<bool>("IsPrivate", ["isPrivate"]);
    }
}
