// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Static Site Linked Backend ARM resource.
/// </summary>
public partial class StaticSiteLinkedBackendInfo : ProvisionableConstruct
{
    /// <summary>
    /// The resource id of the backend linked to the static site.
    /// </summary>
    public BicepValue<string> BackendResourceId 
    {
        get { Initialize(); return _backendResourceId!; }
    }
    private BicepValue<string>? _backendResourceId;

    /// <summary>
    /// The region of the backend linked to the static site.
    /// </summary>
    public BicepValue<string> Region 
    {
        get { Initialize(); return _region!; }
    }
    private BicepValue<string>? _region;

    /// <summary>
    /// The date and time on which the backend was linked to the static site.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The provisioning state of the linking process.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Creates a new StaticSiteLinkedBackendInfo.
    /// </summary>
    public StaticSiteLinkedBackendInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StaticSiteLinkedBackendInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _backendResourceId = DefineProperty<string>("BackendResourceId", ["backendResourceId"], isOutput: true);
        _region = DefineProperty<string>("Region", ["region"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["createdOn"], isOutput: true);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["provisioningState"], isOutput: true);
    }
}
