// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Static Site Database Connection overview.
/// </summary>
public partial class StaticSiteDatabaseConnectionOverview : ProvisionableConstruct
{
    /// <summary>
    /// The resource id of the database.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// If present, the identity is used in conjunction with connection string
    /// to connect to the database. Use of the system-assigned managed
    /// identity is indicated with the string &apos;SystemAssigned&apos;,
    /// while use of a user-assigned managed identity is indicated with the
    /// resource id of the managed identity resource.
    /// </summary>
    public BicepValue<string> ConnectionIdentity 
    {
        get { Initialize(); return _connectionIdentity!; }
    }
    private BicepValue<string>? _connectionIdentity;

    /// <summary>
    /// The region of the database resource.
    /// </summary>
    public BicepValue<string> Region 
    {
        get { Initialize(); return _region!; }
    }
    private BicepValue<string>? _region;

    /// <summary>
    /// A list of configuration files associated with this database connection.
    /// </summary>
    public BicepList<StaticSiteDatabaseConnectionConfigurationFileOverview> ConfigurationFiles 
    {
        get { Initialize(); return _configurationFiles!; }
    }
    private BicepList<StaticSiteDatabaseConnectionConfigurationFileOverview>? _configurationFiles;

    /// <summary>
    /// If present, the name of this database connection resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new StaticSiteDatabaseConnectionOverview.
    /// </summary>
    public StaticSiteDatabaseConnectionOverview()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StaticSiteDatabaseConnectionOverview.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["resourceId"], isOutput: true);
        _connectionIdentity = DefineProperty<string>("ConnectionIdentity", ["connectionIdentity"], isOutput: true);
        _region = DefineProperty<string>("Region", ["region"], isOutput: true);
        _configurationFiles = DefineListProperty<StaticSiteDatabaseConnectionConfigurationFileOverview>("ConfigurationFiles", ["configurationFiles"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
    }
}
