// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// A database connection configuration file.
/// </summary>
public partial class StaticSiteDatabaseConnectionConfigurationFileOverview : ProvisionableConstruct
{
    /// <summary>
    /// The name of the configuration file.
    /// </summary>
    public BicepValue<string> FileName 
    {
        get { Initialize(); return _fileName!; }
    }
    private BicepValue<string>? _fileName;

    /// <summary>
    /// The Base64 encoding of the file contents.
    /// </summary>
    public BicepValue<string> Contents 
    {
        get { Initialize(); return _contents!; }
    }
    private BicepValue<string>? _contents;

    /// <summary>
    /// The type of configuration file.
    /// </summary>
    public BicepValue<string> StaticSiteDatabaseConnectionConfigurationFileOverviewType 
    {
        get { Initialize(); return _staticSiteDatabaseConnectionConfigurationFileOverviewType!; }
    }
    private BicepValue<string>? _staticSiteDatabaseConnectionConfigurationFileOverviewType;

    /// <summary>
    /// Creates a new StaticSiteDatabaseConnectionConfigurationFileOverview.
    /// </summary>
    public StaticSiteDatabaseConnectionConfigurationFileOverview()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StaticSiteDatabaseConnectionConfigurationFileOverview.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _fileName = DefineProperty<string>("FileName", ["fileName"], isOutput: true);
        _contents = DefineProperty<string>("Contents", ["contents"], isOutput: true);
        _staticSiteDatabaseConnectionConfigurationFileOverviewType = DefineProperty<string>("StaticSiteDatabaseConnectionConfigurationFileOverviewType", ["type"], isOutput: true);
    }
}
