// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Build properties for the static site.
/// </summary>
public partial class StaticSiteBuildProperties : ProvisionableConstruct
{
    /// <summary>
    /// The path to the app code within the repository.
    /// </summary>
    public BicepValue<string> AppLocation 
    {
        get { Initialize(); return _appLocation!; }
        set { Initialize(); _appLocation!.Assign(value); }
    }
    private BicepValue<string>? _appLocation;

    /// <summary>
    /// The path to the api code within the repository.
    /// </summary>
    public BicepValue<string> ApiLocation 
    {
        get { Initialize(); return _apiLocation!; }
        set { Initialize(); _apiLocation!.Assign(value); }
    }
    private BicepValue<string>? _apiLocation;

    /// <summary>
    /// Deprecated: The path of the app artifacts after building (deprecated in
    /// favor of OutputLocation).
    /// </summary>
    public BicepValue<string> AppArtifactLocation 
    {
        get { Initialize(); return _appArtifactLocation!; }
        set { Initialize(); _appArtifactLocation!.Assign(value); }
    }
    private BicepValue<string>? _appArtifactLocation;

    /// <summary>
    /// The output path of the app after building.
    /// </summary>
    public BicepValue<string> OutputLocation 
    {
        get { Initialize(); return _outputLocation!; }
        set { Initialize(); _outputLocation!.Assign(value); }
    }
    private BicepValue<string>? _outputLocation;

    /// <summary>
    /// A custom command to run during deployment of the static content
    /// application.
    /// </summary>
    public BicepValue<string> AppBuildCommand 
    {
        get { Initialize(); return _appBuildCommand!; }
        set { Initialize(); _appBuildCommand!.Assign(value); }
    }
    private BicepValue<string>? _appBuildCommand;

    /// <summary>
    /// A custom command to run during deployment of the Azure Functions API
    /// application.
    /// </summary>
    public BicepValue<string> ApiBuildCommand 
    {
        get { Initialize(); return _apiBuildCommand!; }
        set { Initialize(); _apiBuildCommand!.Assign(value); }
    }
    private BicepValue<string>? _apiBuildCommand;

    /// <summary>
    /// Skip Github Action workflow generation.
    /// </summary>
    public BicepValue<bool> SkipGithubActionWorkflowGeneration 
    {
        get { Initialize(); return _skipGithubActionWorkflowGeneration!; }
        set { Initialize(); _skipGithubActionWorkflowGeneration!.Assign(value); }
    }
    private BicepValue<bool>? _skipGithubActionWorkflowGeneration;

    /// <summary>
    /// Github Action secret name override.
    /// </summary>
    public BicepValue<string> GithubActionSecretNameOverride 
    {
        get { Initialize(); return _githubActionSecretNameOverride!; }
        set { Initialize(); _githubActionSecretNameOverride!.Assign(value); }
    }
    private BicepValue<string>? _githubActionSecretNameOverride;

    /// <summary>
    /// Creates a new StaticSiteBuildProperties.
    /// </summary>
    public StaticSiteBuildProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StaticSiteBuildProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _appLocation = DefineProperty<string>("AppLocation", ["appLocation"]);
        _apiLocation = DefineProperty<string>("ApiLocation", ["apiLocation"]);
        _appArtifactLocation = DefineProperty<string>("AppArtifactLocation", ["appArtifactLocation"]);
        _outputLocation = DefineProperty<string>("OutputLocation", ["outputLocation"]);
        _appBuildCommand = DefineProperty<string>("AppBuildCommand", ["appBuildCommand"]);
        _apiBuildCommand = DefineProperty<string>("ApiBuildCommand", ["apiBuildCommand"]);
        _skipGithubActionWorkflowGeneration = DefineProperty<bool>("SkipGithubActionWorkflowGeneration", ["skipGithubActionWorkflowGeneration"]);
        _githubActionSecretNameOverride = DefineProperty<string>("GithubActionSecretNameOverride", ["githubActionSecretNameOverride"]);
    }
}
