// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Trigger based on request execution time.
/// </summary>
public partial class SlowRequestsBasedTrigger : ProvisionableConstruct
{
    /// <summary>
    /// Time taken.
    /// </summary>
    public BicepValue<string> TimeTaken 
    {
        get { Initialize(); return _timeTaken!; }
        set { Initialize(); _timeTaken!.Assign(value); }
    }
    private BicepValue<string>? _timeTaken;

    /// <summary>
    /// Request Path.
    /// </summary>
    public BicepValue<string> Path 
    {
        get { Initialize(); return _path!; }
        set { Initialize(); _path!.Assign(value); }
    }
    private BicepValue<string>? _path;

    /// <summary>
    /// Request Count.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// Time interval.
    /// </summary>
    public BicepValue<string> TimeInterval 
    {
        get { Initialize(); return _timeInterval!; }
        set { Initialize(); _timeInterval!.Assign(value); }
    }
    private BicepValue<string>? _timeInterval;

    /// <summary>
    /// Creates a new SlowRequestsBasedTrigger.
    /// </summary>
    public SlowRequestsBasedTrigger()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SlowRequestsBasedTrigger.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _timeTaken = DefineProperty<string>("TimeTaken", ["timeTaken"]);
        _path = DefineProperty<string>("Path", ["path"]);
        _count = DefineProperty<int>("Count", ["count"]);
        _timeInterval = DefineProperty<string>("TimeInterval", ["timeInterval"]);
    }
}
