// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The status of the last successful slot swap operation.
/// </summary>
public partial class SlotSwapStatus : ProvisionableConstruct
{
    /// <summary>
    /// The time the last successful slot swap completed.
    /// </summary>
    public BicepValue<DateTimeOffset> TimestampUtc 
    {
        get { Initialize(); return _timestampUtc!; }
    }
    private BicepValue<DateTimeOffset>? _timestampUtc;

    /// <summary>
    /// The source slot of the last swap operation.
    /// </summary>
    public BicepValue<string> SourceSlotName 
    {
        get { Initialize(); return _sourceSlotName!; }
    }
    private BicepValue<string>? _sourceSlotName;

    /// <summary>
    /// The destination slot of the last swap operation.
    /// </summary>
    public BicepValue<string> DestinationSlotName 
    {
        get { Initialize(); return _destinationSlotName!; }
    }
    private BicepValue<string>? _destinationSlotName;

    /// <summary>
    /// Creates a new SlotSwapStatus.
    /// </summary>
    public SlotSwapStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SlotSwapStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _timestampUtc = DefineProperty<DateTimeOffset>("TimestampUtc", ["timestampUtc"], isOutput: true);
        _sourceSlotName = DefineProperty<string>("SourceSlotName", ["sourceSlotName"], isOutput: true);
        _destinationSlotName = DefineProperty<string>("DestinationSlotName", ["destinationSlotName"], isOutput: true);
    }
}
